/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include <gr_fir_util.h>
#include <gr_fir_sysconfig.h>

//
// There's no problem that can't be solved by the addition of
// another layer of indirection...
//

// --- constructors ---


gr_fir_CCF *
gr_fir_util::create_gr_fir_CCF (const std::vector<float> &taps)
{
  return gr_fir_sysconfig_singleton()->create_gr_fir_CCF (taps);
}

gr_fir_FCC *
gr_fir_util::create_gr_fir_FCC (const std::vector<VrComplex> &taps)
{
  return gr_fir_sysconfig_singleton()->create_gr_fir_FCC (taps);
}

gr_fir_CCC *
gr_fir_util::create_gr_fir_CCC (const std::vector<VrComplex> &taps)
{
  return gr_fir_sysconfig_singleton()->create_gr_fir_CCC (taps);
}

gr_fir_FFF *
gr_fir_util::create_gr_fir_FFF (const std::vector<float> &taps)
{
  return gr_fir_sysconfig_singleton()->create_gr_fir_FFF (taps);
}

gr_fir_SCC *
gr_fir_util::create_gr_fir_SCC (const std::vector<VrComplex> &taps)
{
  return gr_fir_sysconfig_singleton()->create_gr_fir_SCC (taps);
}

gr_fir_SIS *
gr_fir_util::create_gr_fir_SIS (const std::vector<short> &taps)
{
  return gr_fir_sysconfig_singleton()->create_gr_fir_SIS (taps);
}

gr_fir_FSF *
gr_fir_util::create_gr_fir_FSF (const std::vector<float> &taps)
{
  return gr_fir_sysconfig_singleton()->create_gr_fir_FSF (taps);
}

// --- info gatherers ---


void
gr_fir_util::get_gr_fir_CCF_info (std::vector<gr_fir_CCF_info> *info)
{
  gr_fir_sysconfig_singleton()->get_gr_fir_CCF_info (info);
}

void
gr_fir_util::get_gr_fir_FCC_info (std::vector<gr_fir_FCC_info> *info)
{
  gr_fir_sysconfig_singleton()->get_gr_fir_FCC_info (info);
}

void
gr_fir_util::get_gr_fir_CCC_info (std::vector<gr_fir_CCC_info> *info)
{
  gr_fir_sysconfig_singleton()->get_gr_fir_CCC_info (info);
}

void
gr_fir_util::get_gr_fir_FFF_info (std::vector<gr_fir_FFF_info> *info)
{
  gr_fir_sysconfig_singleton()->get_gr_fir_FFF_info (info);
}

void
gr_fir_util::get_gr_fir_SCC_info (std::vector<gr_fir_SCC_info> *info)
{
  gr_fir_sysconfig_singleton()->get_gr_fir_SCC_info (info);
}

void
gr_fir_util::get_gr_fir_SIS_info (std::vector<gr_fir_SIS_info> *info)
{
  gr_fir_sysconfig_singleton()->get_gr_fir_SIS_info (info);
}

void
gr_fir_util::get_gr_fir_FSF_info (std::vector<gr_fir_FSF_info> *info)
{
  gr_fir_sysconfig_singleton()->get_gr_fir_FSF_info (info);
}
