/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Sample application to illustrate the use of a GrSimpleScopeSink.
 * The input here is provided by the VrSigSource signal generator.
 */

#include <make_GrMC4020Source.h>
#include <VrFileSource.h>
#include <VrFileSink.h>
#include <GrFFTSink.h>
#include <VrFixOffset.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include <GrAGC.h>
#include <VrMixer.h>
#include <GrComplexVCOMixer.h>
#include <VrSigSource.h>
#include <GrMultiply.h>
#include <GrLimiter.h>
#include <GrFastChannelizer.h>
#include <VrComplexFIRfilter.h>
#include <VrRealFIRfilter.h>
#include "VrGUI.h" 

#define SAMPLING_FREQUENCY                         21.52e6
#define	MAX_FREQUENCY		(SAMPLING_FREQUENCY / 2)

#define FROMFILE 1

#define IOTYPE float


int main(int argc, char **argv) {
  VrSource<short> *source;
  GrFFTSink<IOTYPE> *scope_sink;
  GrFFTSink<IOTYPE> *real_sink;
  GrFFTSink<IOTYPE> *imag_sink;
  GrFFTSink<IOTYPE> *misc_fft1;
  GrFFTSink<IOTYPE> *misc_fft2;

  VrFileSink<IOTYPE> *filesink;
  VrFileSink<IOTYPE> *filesink2;
  VrFileSink<IOTYPE> *filesink3;

  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();
  VrGUILayout *vert2 = horiz->horizontal()->vertical();

  VrFixOffset<short,IOTYPE> *offset_fixer;
  GrAGC<IOTYPE,IOTYPE> *agc_block;
  GrComplexVCOMixer<IOTYPE,IOTYPE> *mixer;
  VrSigSource<IOTYPE> *zero;
  GrMultiply<IOTYPE,IOTYPE> *phase_det;
  GrLimiter<IOTYPE,IOTYPE> *limiter;
  VrRealFIRfilter<IOTYPE,IOTYPE> *afc_lpf;
  VrRealFIRfilter<IOTYPE,IOTYPE> *apc_lpf;
  //GrFastChannelizer<IOTYPE> *afc_lpf;


  if(FROMFILE)
  	source = new VrFileSource<short>(SAMPLING_FREQUENCY,"hdtv_563.dat",0);
  else
  	source = make_GrMC4020SourceS(SAMPLING_FREQUENCY,
				MCC_CLK_AD_START_TRIG_IN | MCC_EXT_BNC_THRESH_ZERO
				| MCC_CH3_EN | MCC_ALL_1V);
  
  offset_fixer = new VrFixOffset<short,IOTYPE>();
  scope_sink = new GrFFTSink<IOTYPE>(vert, 0, 100, 512);
  real_sink = new GrFFTSink<IOTYPE>(vert, 0, 100, 512);
  imag_sink = new GrFFTSink<IOTYPE>(vert, 0, 100, 512);
  agc_block = new GrAGC<IOTYPE,IOTYPE>(1000);
  mixer = new GrComplexVCOMixer<IOTYPE,IOTYPE>(3e6,0);
  zero = new VrSigSource<IOTYPE>(SAMPLING_FREQUENCY,VR_DC_WAVE,0,0);
  phase_det = new GrMultiply<IOTYPE,IOTYPE>();
  limiter = new GrLimiter<IOTYPE,IOTYPE>();

  misc_fft1 = new GrFFTSink<IOTYPE>(vert2, 0, 80, 512);
  misc_fft2 = new GrFFTSink<IOTYPE>(vert2, 0, 100, 512);

  afc_lpf = new VrRealFIRfilter<IOTYPE,IOTYPE>(0, 200, 1); // Could dec by 40
  apc_lpf = new VrRealFIRfilter<IOTYPE,IOTYPE>(0, 1000, 1); 

  filesink = new VrFileSink<IOTYPE>("filtered.dat");
  filesink2 = new VrFileSink<IOTYPE>("limited.dat");
  filesink3 = new VrFileSink<IOTYPE>("lpf.dat");

  NWO_CONNECT (source, offset_fixer);
  NWO_CONNECT (offset_fixer, scope_sink);
  NWO_CONNECT (offset_fixer, mixer);
  
  NWO_CONNECT (zero, mixer);
  //NWO_CONNECT (apc_lpf, mixer);
  
    NWO_CONNECT (limiter, phase_det);
  NWO_CONNECTN (mixer, 1, phase_det);
  NWO_CONNECT (phase_det, apc_lpf);
  NWO_CONNECTN (mixer, 0, afc_lpf);
  NWO_CONNECT (afc_lpf, limiter);

  NWO_CONNECT (limiter, misc_fft1);
  NWO_CONNECT (afc_lpf, misc_fft2);
  NWO_CONNECTN (mixer, 0, real_sink);
  NWO_CONNECT (apc_lpf, filesink3);
  NWO_CONNECTN (mixer, 1, imag_sink);
  NWO_CONNECT (afc_lpf, filesink);
  NWO_CONNECT (limiter, filesink2);

  //NWO_CONNECT (offset_fixer, agc_block);
  //NWO_CONNECT (agc_block, agc_scope_sink);

  VrMultiTask *m = new VrMultiTask ();

  m->add (scope_sink);
  m->add (real_sink);
  m->add (imag_sink);

  m->add (misc_fft1);
  m->add (misc_fft2);

  m->add (filesink);
  m->add (filesink2);
  m->add (filesink3);

  m->start();

  guimain->start();

  while (1) {
    guimain->processEvents(10 /*ms*/);
    m->process();
  }
}
