#ifndef	_mach4_user_
#define	_mach4_user_

/* Module mach4 */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>

/* Routine task_enable_pc_sampling */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __task_enable_pc_sampling
#if	defined(LINTLIBRARY)
    (host, tick, flavor)
	mach_port_t host;
	int *tick;
	sampled_pc_flavor_t flavor;
{ return __task_enable_pc_sampling(host, tick, flavor); }
#else
(
	mach_port_t host,
	int *tick,
	sampled_pc_flavor_t flavor
);
#endif

/* Routine task_disable_pc_sampling */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __task_disable_pc_sampling
#if	defined(LINTLIBRARY)
    (host, samplecnt)
	mach_port_t host;
	int *samplecnt;
{ return __task_disable_pc_sampling(host, samplecnt); }
#else
(
	mach_port_t host,
	int *samplecnt
);
#endif

/* Routine task_get_sampled_pcs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __task_get_sampled_pcs
#if	defined(LINTLIBRARY)
    (host, seqno, sampled_pcs, sampled_pcsCnt)
	mach_port_t host;
	sampled_pc_seqno_t *seqno;
	sampled_pc_array_t sampled_pcs;
	mach_msg_type_number_t *sampled_pcsCnt;
{ return __task_get_sampled_pcs(host, seqno, sampled_pcs, sampled_pcsCnt); }
#else
(
	mach_port_t host,
	sampled_pc_seqno_t *seqno,
	sampled_pc_array_t sampled_pcs,
	mach_msg_type_number_t *sampled_pcsCnt
);
#endif

/* Routine thread_enable_pc_sampling */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __thread_enable_pc_sampling
#if	defined(LINTLIBRARY)
    (host, tick, flavor)
	mach_port_t host;
	int *tick;
	sampled_pc_flavor_t flavor;
{ return __thread_enable_pc_sampling(host, tick, flavor); }
#else
(
	mach_port_t host,
	int *tick,
	sampled_pc_flavor_t flavor
);
#endif

/* Routine thread_disable_pc_sampling */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __thread_disable_pc_sampling
#if	defined(LINTLIBRARY)
    (host, samplecnt)
	mach_port_t host;
	int *samplecnt;
{ return __thread_disable_pc_sampling(host, samplecnt); }
#else
(
	mach_port_t host,
	int *samplecnt
);
#endif

/* Routine thread_get_sampled_pcs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __thread_get_sampled_pcs
#if	defined(LINTLIBRARY)
    (host, seqno, sampled_pcs, sampled_pcsCnt)
	mach_port_t host;
	sampled_pc_seqno_t *seqno;
	sampled_pc_array_t sampled_pcs;
	mach_msg_type_number_t *sampled_pcsCnt;
{ return __thread_get_sampled_pcs(host, seqno, sampled_pcs, sampled_pcsCnt); }
#else
(
	mach_port_t host,
	sampled_pc_seqno_t *seqno,
	sampled_pc_array_t sampled_pcs,
	mach_msg_type_number_t *sampled_pcsCnt
);
#endif


/* Module mach4 */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>

/* Routine task_enable_pc_sampling */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t task_enable_pc_sampling
#if	defined(LINTLIBRARY)
    (host, tick, flavor)
	mach_port_t host;
	int *tick;
	sampled_pc_flavor_t flavor;
{ return task_enable_pc_sampling(host, tick, flavor); }
#else
(
	mach_port_t host,
	int *tick,
	sampled_pc_flavor_t flavor
);
#endif

/* Routine task_disable_pc_sampling */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t task_disable_pc_sampling
#if	defined(LINTLIBRARY)
    (host, samplecnt)
	mach_port_t host;
	int *samplecnt;
{ return task_disable_pc_sampling(host, samplecnt); }
#else
(
	mach_port_t host,
	int *samplecnt
);
#endif

/* Routine task_get_sampled_pcs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t task_get_sampled_pcs
#if	defined(LINTLIBRARY)
    (host, seqno, sampled_pcs, sampled_pcsCnt)
	mach_port_t host;
	sampled_pc_seqno_t *seqno;
	sampled_pc_array_t sampled_pcs;
	mach_msg_type_number_t *sampled_pcsCnt;
{ return task_get_sampled_pcs(host, seqno, sampled_pcs, sampled_pcsCnt); }
#else
(
	mach_port_t host,
	sampled_pc_seqno_t *seqno,
	sampled_pc_array_t sampled_pcs,
	mach_msg_type_number_t *sampled_pcsCnt
);
#endif

/* Routine thread_enable_pc_sampling */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t thread_enable_pc_sampling
#if	defined(LINTLIBRARY)
    (host, tick, flavor)
	mach_port_t host;
	int *tick;
	sampled_pc_flavor_t flavor;
{ return thread_enable_pc_sampling(host, tick, flavor); }
#else
(
	mach_port_t host,
	int *tick,
	sampled_pc_flavor_t flavor
);
#endif

/* Routine thread_disable_pc_sampling */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t thread_disable_pc_sampling
#if	defined(LINTLIBRARY)
    (host, samplecnt)
	mach_port_t host;
	int *samplecnt;
{ return thread_disable_pc_sampling(host, samplecnt); }
#else
(
	mach_port_t host,
	int *samplecnt
);
#endif

/* Routine thread_get_sampled_pcs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t thread_get_sampled_pcs
#if	defined(LINTLIBRARY)
    (host, seqno, sampled_pcs, sampled_pcsCnt)
	mach_port_t host;
	sampled_pc_seqno_t *seqno;
	sampled_pc_array_t sampled_pcs;
	mach_msg_type_number_t *sampled_pcsCnt;
{ return thread_get_sampled_pcs(host, seqno, sampled_pcs, sampled_pcsCnt); }
#else
(
	mach_port_t host,
	sampled_pc_seqno_t *seqno,
	sampled_pc_array_t sampled_pcs,
	mach_msg_type_number_t *sampled_pcsCnt
);
#endif

#endif	/* not defined(_mach4_user_) */
