#ifndef	_socket_user_
#define	_socket_user_

/* Module socket */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine socket_create */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_create
#if	defined(LINTLIBRARY)
    (server, sock_type, protocol, sock)
	pf_t server;
	int sock_type;
	int protocol;
	mach_port_t *sock;
{ return __socket_create(server, sock_type, protocol, sock); }
#else
(
	pf_t server,
	int sock_type,
	int protocol,
	mach_port_t *sock
);
#endif

/* Routine socket_listen */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_listen
#if	defined(LINTLIBRARY)
    (sock, queue_limit)
	socket_t sock;
	int queue_limit;
{ return __socket_listen(sock, queue_limit); }
#else
(
	socket_t sock,
	int queue_limit
);
#endif

/* Routine socket_accept */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_accept
#if	defined(LINTLIBRARY)
    (sock, conn_sock, peer_addr)
	socket_t sock;
	mach_port_t *conn_sock;
	mach_port_t *peer_addr;
{ return __socket_accept(sock, conn_sock, peer_addr); }
#else
(
	socket_t sock,
	mach_port_t *conn_sock,
	mach_port_t *peer_addr
);
#endif

/* Routine socket_connect */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_connect
#if	defined(LINTLIBRARY)
    (sock, addr)
	socket_t sock;
	addr_port_t addr;
{ return __socket_connect(sock, addr); }
#else
(
	socket_t sock,
	addr_port_t addr
);
#endif

/* Routine socket_bind */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_bind
#if	defined(LINTLIBRARY)
    (sock, addr)
	socket_t sock;
	addr_port_t addr;
{ return __socket_bind(sock, addr); }
#else
(
	socket_t sock,
	addr_port_t addr
);
#endif

/* Routine socket_name */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_name
#if	defined(LINTLIBRARY)
    (sock, addr)
	socket_t sock;
	mach_port_t *addr;
{ return __socket_name(sock, addr); }
#else
(
	socket_t sock,
	mach_port_t *addr
);
#endif

/* Routine socket_peername */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_peername
#if	defined(LINTLIBRARY)
    (sock, addr)
	socket_t sock;
	mach_port_t *addr;
{ return __socket_peername(sock, addr); }
#else
(
	socket_t sock,
	mach_port_t *addr
);
#endif

/* Routine socket_connect2 */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_connect2
#if	defined(LINTLIBRARY)
    (sock1, sock2)
	socket_t sock1;
	socket_t sock2;
{ return __socket_connect2(sock1, sock2); }
#else
(
	socket_t sock1,
	socket_t sock2
);
#endif

/* Routine socket_create_address */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_create_address
#if	defined(LINTLIBRARY)
    (server, sockaddr_type, sockaddr, sockaddrCnt, addr)
	mach_port_t server;
	int sockaddr_type;
	data_t sockaddr;
	mach_msg_type_number_t sockaddrCnt;
	mach_port_t *addr;
{ return __socket_create_address(server, sockaddr_type, sockaddr, sockaddrCnt, addr); }
#else
(
	mach_port_t server,
	int sockaddr_type,
	data_t sockaddr,
	mach_msg_type_number_t sockaddrCnt,
	mach_port_t *addr
);
#endif

/* Routine socket_fabricate_address */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_fabricate_address
#if	defined(LINTLIBRARY)
    (server, sockaddr_type, addr)
	mach_port_t server;
	int sockaddr_type;
	mach_port_t *addr;
{ return __socket_fabricate_address(server, sockaddr_type, addr); }
#else
(
	mach_port_t server,
	int sockaddr_type,
	mach_port_t *addr
);
#endif

/* Routine socket_whatis_address */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_whatis_address
#if	defined(LINTLIBRARY)
    (addr, sockaddr_type, sockaddr, sockaddrCnt)
	addr_port_t addr;
	int *sockaddr_type;
	data_t *sockaddr;
	mach_msg_type_number_t *sockaddrCnt;
{ return __socket_whatis_address(addr, sockaddr_type, sockaddr, sockaddrCnt); }
#else
(
	addr_port_t addr,
	int *sockaddr_type,
	data_t *sockaddr,
	mach_msg_type_number_t *sockaddrCnt
);
#endif

/* Routine socket_shutdown */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_shutdown
#if	defined(LINTLIBRARY)
    (sock, direction)
	socket_t sock;
	int direction;
{ return __socket_shutdown(sock, direction); }
#else
(
	socket_t sock,
	int direction
);
#endif

/* Routine socket_getopt */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_getopt
#if	defined(LINTLIBRARY)
    (sock, level, option, optval, optvalCnt)
	socket_t sock;
	int level;
	int option;
	data_t *optval;
	mach_msg_type_number_t *optvalCnt;
{ return __socket_getopt(sock, level, option, optval, optvalCnt); }
#else
(
	socket_t sock,
	int level,
	int option,
	data_t *optval,
	mach_msg_type_number_t *optvalCnt
);
#endif

/* Routine socket_setopt */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_setopt
#if	defined(LINTLIBRARY)
    (sock, level, option, optval, optvalCnt)
	socket_t sock;
	int level;
	int option;
	data_t optval;
	mach_msg_type_number_t optvalCnt;
{ return __socket_setopt(sock, level, option, optval, optvalCnt); }
#else
(
	socket_t sock,
	int level,
	int option,
	data_t optval,
	mach_msg_type_number_t optvalCnt
);
#endif

/* Routine socket_send */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_send
#if	defined(LINTLIBRARY)
    (sock, addr, flags, data, dataCnt, ports, portsPoly, portsCnt, control, controlCnt, amount)
	socket_t sock;
	addr_port_t addr;
	int flags;
	data_t data;
	mach_msg_type_number_t dataCnt;
	portarray_t ports;
	mach_msg_type_name_t portsPoly;
	mach_msg_type_number_t portsCnt;
	data_t control;
	mach_msg_type_number_t controlCnt;
	mach_msg_type_number_t *amount;
{ return __socket_send(sock, addr, flags, data, dataCnt, ports, portsPoly, portsCnt, control, controlCnt, amount); }
#else
(
	socket_t sock,
	addr_port_t addr,
	int flags,
	data_t data,
	mach_msg_type_number_t dataCnt,
	portarray_t ports,
	mach_msg_type_name_t portsPoly,
	mach_msg_type_number_t portsCnt,
	data_t control,
	mach_msg_type_number_t controlCnt,
	mach_msg_type_number_t *amount
);
#endif

/* Routine socket_recv */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __socket_recv
#if	defined(LINTLIBRARY)
    (sock, addr, flags, data, dataCnt, ports, portsCnt, control, controlCnt, outflags, amount)
	socket_t sock;
	mach_port_t *addr;
	int flags;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
	portarray_t *ports;
	mach_msg_type_number_t *portsCnt;
	data_t *control;
	mach_msg_type_number_t *controlCnt;
	int *outflags;
	mach_msg_type_number_t amount;
{ return __socket_recv(sock, addr, flags, data, dataCnt, ports, portsCnt, control, controlCnt, outflags, amount); }
#else
(
	socket_t sock,
	mach_port_t *addr,
	int flags,
	data_t *data,
	mach_msg_type_number_t *dataCnt,
	portarray_t *ports,
	mach_msg_type_number_t *portsCnt,
	data_t *control,
	mach_msg_type_number_t *controlCnt,
	int *outflags,
	mach_msg_type_number_t amount
);
#endif


/* Module socket */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine socket_create */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_create
#if	defined(LINTLIBRARY)
    (server, sock_type, protocol, sock)
	pf_t server;
	int sock_type;
	int protocol;
	mach_port_t *sock;
{ return socket_create(server, sock_type, protocol, sock); }
#else
(
	pf_t server,
	int sock_type,
	int protocol,
	mach_port_t *sock
);
#endif

/* Routine socket_listen */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_listen
#if	defined(LINTLIBRARY)
    (sock, queue_limit)
	socket_t sock;
	int queue_limit;
{ return socket_listen(sock, queue_limit); }
#else
(
	socket_t sock,
	int queue_limit
);
#endif

/* Routine socket_accept */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_accept
#if	defined(LINTLIBRARY)
    (sock, conn_sock, peer_addr)
	socket_t sock;
	mach_port_t *conn_sock;
	mach_port_t *peer_addr;
{ return socket_accept(sock, conn_sock, peer_addr); }
#else
(
	socket_t sock,
	mach_port_t *conn_sock,
	mach_port_t *peer_addr
);
#endif

/* Routine socket_connect */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_connect
#if	defined(LINTLIBRARY)
    (sock, addr)
	socket_t sock;
	addr_port_t addr;
{ return socket_connect(sock, addr); }
#else
(
	socket_t sock,
	addr_port_t addr
);
#endif

/* Routine socket_bind */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_bind
#if	defined(LINTLIBRARY)
    (sock, addr)
	socket_t sock;
	addr_port_t addr;
{ return socket_bind(sock, addr); }
#else
(
	socket_t sock,
	addr_port_t addr
);
#endif

/* Routine socket_name */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_name
#if	defined(LINTLIBRARY)
    (sock, addr)
	socket_t sock;
	mach_port_t *addr;
{ return socket_name(sock, addr); }
#else
(
	socket_t sock,
	mach_port_t *addr
);
#endif

/* Routine socket_peername */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_peername
#if	defined(LINTLIBRARY)
    (sock, addr)
	socket_t sock;
	mach_port_t *addr;
{ return socket_peername(sock, addr); }
#else
(
	socket_t sock,
	mach_port_t *addr
);
#endif

/* Routine socket_connect2 */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_connect2
#if	defined(LINTLIBRARY)
    (sock1, sock2)
	socket_t sock1;
	socket_t sock2;
{ return socket_connect2(sock1, sock2); }
#else
(
	socket_t sock1,
	socket_t sock2
);
#endif

/* Routine socket_create_address */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_create_address
#if	defined(LINTLIBRARY)
    (server, sockaddr_type, sockaddr, sockaddrCnt, addr)
	mach_port_t server;
	int sockaddr_type;
	data_t sockaddr;
	mach_msg_type_number_t sockaddrCnt;
	mach_port_t *addr;
{ return socket_create_address(server, sockaddr_type, sockaddr, sockaddrCnt, addr); }
#else
(
	mach_port_t server,
	int sockaddr_type,
	data_t sockaddr,
	mach_msg_type_number_t sockaddrCnt,
	mach_port_t *addr
);
#endif

/* Routine socket_fabricate_address */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_fabricate_address
#if	defined(LINTLIBRARY)
    (server, sockaddr_type, addr)
	mach_port_t server;
	int sockaddr_type;
	mach_port_t *addr;
{ return socket_fabricate_address(server, sockaddr_type, addr); }
#else
(
	mach_port_t server,
	int sockaddr_type,
	mach_port_t *addr
);
#endif

/* Routine socket_whatis_address */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_whatis_address
#if	defined(LINTLIBRARY)
    (addr, sockaddr_type, sockaddr, sockaddrCnt)
	addr_port_t addr;
	int *sockaddr_type;
	data_t *sockaddr;
	mach_msg_type_number_t *sockaddrCnt;
{ return socket_whatis_address(addr, sockaddr_type, sockaddr, sockaddrCnt); }
#else
(
	addr_port_t addr,
	int *sockaddr_type,
	data_t *sockaddr,
	mach_msg_type_number_t *sockaddrCnt
);
#endif

/* Routine socket_shutdown */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_shutdown
#if	defined(LINTLIBRARY)
    (sock, direction)
	socket_t sock;
	int direction;
{ return socket_shutdown(sock, direction); }
#else
(
	socket_t sock,
	int direction
);
#endif

/* Routine socket_getopt */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_getopt
#if	defined(LINTLIBRARY)
    (sock, level, option, optval, optvalCnt)
	socket_t sock;
	int level;
	int option;
	data_t *optval;
	mach_msg_type_number_t *optvalCnt;
{ return socket_getopt(sock, level, option, optval, optvalCnt); }
#else
(
	socket_t sock,
	int level,
	int option,
	data_t *optval,
	mach_msg_type_number_t *optvalCnt
);
#endif

/* Routine socket_setopt */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_setopt
#if	defined(LINTLIBRARY)
    (sock, level, option, optval, optvalCnt)
	socket_t sock;
	int level;
	int option;
	data_t optval;
	mach_msg_type_number_t optvalCnt;
{ return socket_setopt(sock, level, option, optval, optvalCnt); }
#else
(
	socket_t sock,
	int level,
	int option,
	data_t optval,
	mach_msg_type_number_t optvalCnt
);
#endif

/* Routine socket_send */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_send
#if	defined(LINTLIBRARY)
    (sock, addr, flags, data, dataCnt, ports, portsPoly, portsCnt, control, controlCnt, amount)
	socket_t sock;
	addr_port_t addr;
	int flags;
	data_t data;
	mach_msg_type_number_t dataCnt;
	portarray_t ports;
	mach_msg_type_name_t portsPoly;
	mach_msg_type_number_t portsCnt;
	data_t control;
	mach_msg_type_number_t controlCnt;
	mach_msg_type_number_t *amount;
{ return socket_send(sock, addr, flags, data, dataCnt, ports, portsPoly, portsCnt, control, controlCnt, amount); }
#else
(
	socket_t sock,
	addr_port_t addr,
	int flags,
	data_t data,
	mach_msg_type_number_t dataCnt,
	portarray_t ports,
	mach_msg_type_name_t portsPoly,
	mach_msg_type_number_t portsCnt,
	data_t control,
	mach_msg_type_number_t controlCnt,
	mach_msg_type_number_t *amount
);
#endif

/* Routine socket_recv */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t socket_recv
#if	defined(LINTLIBRARY)
    (sock, addr, flags, data, dataCnt, ports, portsCnt, control, controlCnt, outflags, amount)
	socket_t sock;
	mach_port_t *addr;
	int flags;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
	portarray_t *ports;
	mach_msg_type_number_t *portsCnt;
	data_t *control;
	mach_msg_type_number_t *controlCnt;
	int *outflags;
	mach_msg_type_number_t amount;
{ return socket_recv(sock, addr, flags, data, dataCnt, ports, portsCnt, control, controlCnt, outflags, amount); }
#else
(
	socket_t sock,
	mach_port_t *addr,
	int flags,
	data_t *data,
	mach_msg_type_number_t *dataCnt,
	portarray_t *ports,
	mach_msg_type_number_t *portsCnt,
	data_t *control,
	mach_msg_type_number_t *controlCnt,
	int *outflags,
	mach_msg_type_number_t amount
);
#endif

#endif	/* not defined(_socket_user_) */
