#ifndef	_process_user_
#define	_process_user_

/* Module process */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* SimpleRoutine proc_sethostid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_sethostid_request
#if	defined(LINTLIBRARY)
    (process, reply, hostid)
	process_t process;
	mach_port_t reply;
	int hostid;
{ return __proc_sethostid_request(process, reply, hostid); }
#else
(
	process_t process,
	mach_port_t reply,
	int hostid
);
#endif

/* SimpleRoutine proc_gethostid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_gethostid_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_gethostid_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_sethostname_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_sethostname_request
#if	defined(LINTLIBRARY)
    (process, reply, hostname, hostnameCnt)
	process_t process;
	mach_port_t reply;
	data_t hostname;
	mach_msg_type_number_t hostnameCnt;
{ return __proc_sethostname_request(process, reply, hostname, hostnameCnt); }
#else
(
	process_t process,
	mach_port_t reply,
	data_t hostname,
	mach_msg_type_number_t hostnameCnt
);
#endif

/* SimpleRoutine proc_gethostname_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_gethostname_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_gethostname_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getprivports_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getprivports_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_getprivports_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getallpids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getallpids_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_getallpids_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_setexecdata_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setexecdata_request
#if	defined(LINTLIBRARY)
    (process, reply, ports, portsPoly, portsCnt, ints, intsCnt)
	process_t process;
	mach_port_t reply;
	portarray_t ports;
	mach_msg_type_name_t portsPoly;
	mach_msg_type_number_t portsCnt;
	intarray_t ints;
	mach_msg_type_number_t intsCnt;
{ return __proc_setexecdata_request(process, reply, ports, portsPoly, portsCnt, ints, intsCnt); }
#else
(
	process_t process,
	mach_port_t reply,
	portarray_t ports,
	mach_msg_type_name_t portsPoly,
	mach_msg_type_number_t portsCnt,
	intarray_t ints,
	mach_msg_type_number_t intsCnt
);
#endif

/* SimpleRoutine proc_getexecdata_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getexecdata_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_getexecdata_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_execdata_notify_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_execdata_notify_request
#if	defined(LINTLIBRARY)
    (process, reply, notify, notifyPoly)
	process_t process;
	mach_port_t reply;
	mach_port_t notify;
	mach_msg_type_name_t notifyPoly;
{ return __proc_execdata_notify_request(process, reply, notify, notifyPoly); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t notify,
	mach_msg_type_name_t notifyPoly
);
#endif

/* SimpleRoutine proc_uname_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_uname_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_uname_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_register_version_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_register_version_request
#if	defined(LINTLIBRARY)
    (process, reply, credential, name, release, version)
	process_t process;
	mach_port_t reply;
	mach_port_t credential;
	string_t name;
	string_t release;
	string_t version;
{ return __proc_register_version_request(process, reply, credential, name, release, version); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t credential,
	string_t name,
	string_t release,
	string_t version
);
#endif

/* SimpleRoutine proc_reauthenticate_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_reauthenticate_request
#if	defined(LINTLIBRARY)
    (process, reply, rendezvous2, rendezvous2Poly)
	process_t process;
	mach_port_t reply;
	mach_port_t rendezvous2;
	mach_msg_type_name_t rendezvous2Poly;
{ return __proc_reauthenticate_request(process, reply, rendezvous2, rendezvous2Poly); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t rendezvous2,
	mach_msg_type_name_t rendezvous2Poly
);
#endif

/* SimpleRoutine proc_child_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_child_request
#if	defined(LINTLIBRARY)
    (process, reply, child)
	process_t process;
	mach_port_t reply;
	mach_port_t child;
{ return __proc_child_request(process, reply, child); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t child
);
#endif

/* SimpleRoutine proc_setmsgport_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setmsgport_request
#if	defined(LINTLIBRARY)
    (process, reply, newmsgport)
	process_t process;
	mach_port_t reply;
	mach_port_t newmsgport;
{ return __proc_setmsgport_request(process, reply, newmsgport); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t newmsgport
);
#endif

/* SimpleRoutine proc_reassign_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_reassign_request
#if	defined(LINTLIBRARY)
    (process, reply, newtask)
	process_t process;
	mach_port_t reply;
	mach_port_t newtask;
{ return __proc_reassign_request(process, reply, newtask); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t newtask
);
#endif

/* SimpleRoutine proc_setowner_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setowner_request
#if	defined(LINTLIBRARY)
    (process, reply, owner, clear)
	process_t process;
	mach_port_t reply;
	uid_t owner;
	int clear;
{ return __proc_setowner_request(process, reply, owner, clear); }
#else
(
	process_t process,
	mach_port_t reply,
	uid_t owner,
	int clear
);
#endif

/* SimpleRoutine proc_getpids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getpids_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_getpids_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_set_arg_locations_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_set_arg_locations_request
#if	defined(LINTLIBRARY)
    (process, reply, argv, envp)
	process_t process;
	mach_port_t reply;
	vm_address_t argv;
	vm_address_t envp;
{ return __proc_set_arg_locations_request(process, reply, argv, envp); }
#else
(
	process_t process,
	mach_port_t reply,
	vm_address_t argv,
	vm_address_t envp
);
#endif

/* SimpleRoutine proc_get_arg_locations_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_get_arg_locations_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_get_arg_locations_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getmsgport_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getmsgport_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return __proc_getmsgport_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_wait_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_wait_request
#if	defined(LINTLIBRARY)
    (process, reply, pid, options)
	process_t process;
	mach_port_t reply;
	pid_t pid;
	int options;
{ return __proc_wait_request(process, reply, pid, options); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid,
	int options
);
#endif

/* SimpleRoutine proc_dostop_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_dostop_request
#if	defined(LINTLIBRARY)
    (process, reply, contthread)
	process_t process;
	mach_port_t reply;
	mach_port_t contthread;
{ return __proc_dostop_request(process, reply, contthread); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t contthread
);
#endif

/* SimpleRoutine proc_handle_exceptions_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_handle_exceptions_request
#if	defined(LINTLIBRARY)
    (process, reply, msgport, forwardport, forwardportPoly, flavor, new_state, new_stateCnt)
	process_t process;
	mach_port_t reply;
	mach_port_t msgport;
	mach_port_t forwardport;
	mach_msg_type_name_t forwardportPoly;
	int flavor;
	thread_state_t new_state;
	mach_msg_type_number_t new_stateCnt;
{ return __proc_handle_exceptions_request(process, reply, msgport, forwardport, forwardportPoly, flavor, new_state, new_stateCnt); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t msgport,
	mach_port_t forwardport,
	mach_msg_type_name_t forwardportPoly,
	int flavor,
	thread_state_t new_state,
	mach_msg_type_number_t new_stateCnt
);
#endif

/* SimpleRoutine proc_mark_stop_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_stop_request
#if	defined(LINTLIBRARY)
    (process, reply, signo, sigcode)
	process_t process;
	mach_port_t reply;
	int signo;
	int sigcode;
{ return __proc_mark_stop_request(process, reply, signo, sigcode); }
#else
(
	process_t process,
	mach_port_t reply,
	int signo,
	int sigcode
);
#endif

/* SimpleRoutine proc_mark_cont_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_cont_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_mark_cont_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_mark_exit_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_exit_request
#if	defined(LINTLIBRARY)
    (process, reply, status, sigcode)
	process_t process;
	mach_port_t reply;
	int status;
	int sigcode;
{ return __proc_mark_exit_request(process, reply, status, sigcode); }
#else
(
	process_t process,
	mach_port_t reply,
	int status,
	int sigcode
);
#endif

/* SimpleRoutine proc_mark_exec_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_exec_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_mark_exec_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_mark_traced_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mark_traced_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_mark_traced_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_mod_stopchild_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_mod_stopchild_request
#if	defined(LINTLIBRARY)
    (process, reply, doit)
	process_t process;
	mach_port_t reply;
	int doit;
{ return __proc_mod_stopchild_request(process, reply, doit); }
#else
(
	process_t process,
	mach_port_t reply,
	int doit
);
#endif

/* SimpleRoutine proc_pid2task_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_pid2task_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return __proc_pid2task_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_task2pid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_task2pid_request
#if	defined(LINTLIBRARY)
    (process, reply, task)
	process_t process;
	mach_port_t reply;
	mach_port_t task;
{ return __proc_task2pid_request(process, reply, task); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t task
);
#endif

/* SimpleRoutine proc_task2proc_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_task2proc_request
#if	defined(LINTLIBRARY)
    (process, reply, task)
	process_t process;
	mach_port_t reply;
	mach_port_t task;
{ return __proc_task2proc_request(process, reply, task); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t task
);
#endif

/* SimpleRoutine proc_proc2task_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_proc2task_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_proc2task_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_pid2proc_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_pid2proc_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return __proc_pid2proc_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_getprocinfo_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getprocinfo_request
#if	defined(LINTLIBRARY)
    (process, reply, which, flags)
	process_t process;
	mach_port_t reply;
	pid_t which;
	int flags;
{ return __proc_getprocinfo_request(process, reply, which, flags); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t which,
	int flags
);
#endif

/* SimpleRoutine proc_getprocargs_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getprocargs_request
#if	defined(LINTLIBRARY)
    (process, reply, which)
	process_t process;
	mach_port_t reply;
	pid_t which;
{ return __proc_getprocargs_request(process, reply, which); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t which
);
#endif

/* SimpleRoutine proc_getprocenv_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getprocenv_request
#if	defined(LINTLIBRARY)
    (process, reply, which)
	process_t process;
	mach_port_t reply;
	pid_t which;
{ return __proc_getprocenv_request(process, reply, which); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t which
);
#endif

/* SimpleRoutine proc_make_login_coll_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_make_login_coll_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_make_login_coll_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getloginid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getloginid_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return __proc_getloginid_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_getloginpids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getloginpids_request
#if	defined(LINTLIBRARY)
    (process, reply, id)
	process_t process;
	mach_port_t reply;
	pid_t id;
{ return __proc_getloginpids_request(process, reply, id); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t id
);
#endif

/* SimpleRoutine proc_setlogin_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setlogin_request
#if	defined(LINTLIBRARY)
    (process, reply, logname)
	process_t process;
	mach_port_t reply;
	string_t logname;
{ return __proc_setlogin_request(process, reply, logname); }
#else
(
	process_t process,
	mach_port_t reply,
	string_t logname
);
#endif

/* SimpleRoutine proc_getlogin_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getlogin_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_getlogin_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_setsid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setsid_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_setsid_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getsid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getsid_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return __proc_getsid_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_getsessionpgids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getsessionpgids_request
#if	defined(LINTLIBRARY)
    (process, reply, sid)
	process_t process;
	mach_port_t reply;
	pid_t sid;
{ return __proc_getsessionpgids_request(process, reply, sid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t sid
);
#endif

/* SimpleRoutine proc_getsessionpids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getsessionpids_request
#if	defined(LINTLIBRARY)
    (process, reply, sid)
	process_t process;
	mach_port_t reply;
	pid_t sid;
{ return __proc_getsessionpids_request(process, reply, sid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t sid
);
#endif

/* SimpleRoutine proc_getsidport_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getsidport_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return __proc_getsidport_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_setpgrp_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_setpgrp_request
#if	defined(LINTLIBRARY)
    (process, reply, pid, pgrp)
	process_t process;
	mach_port_t reply;
	pid_t pid;
	pid_t pgrp;
{ return __proc_setpgrp_request(process, reply, pid, pgrp); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid,
	pid_t pgrp
);
#endif

/* SimpleRoutine proc_getpgrp_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getpgrp_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return __proc_getpgrp_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_getpgrppids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_getpgrppids_request
#if	defined(LINTLIBRARY)
    (process, reply, pgrp)
	process_t process;
	mach_port_t reply;
	pid_t pgrp;
{ return __proc_getpgrppids_request(process, reply, pgrp); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pgrp
);
#endif

/* SimpleRoutine proc_get_tty_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __proc_get_tty_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return __proc_get_tty_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif


/* Module process */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* SimpleRoutine proc_sethostid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_sethostid_request
#if	defined(LINTLIBRARY)
    (process, reply, hostid)
	process_t process;
	mach_port_t reply;
	int hostid;
{ return proc_sethostid_request(process, reply, hostid); }
#else
(
	process_t process,
	mach_port_t reply,
	int hostid
);
#endif

/* SimpleRoutine proc_gethostid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_gethostid_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_gethostid_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_sethostname_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_sethostname_request
#if	defined(LINTLIBRARY)
    (process, reply, hostname, hostnameCnt)
	process_t process;
	mach_port_t reply;
	data_t hostname;
	mach_msg_type_number_t hostnameCnt;
{ return proc_sethostname_request(process, reply, hostname, hostnameCnt); }
#else
(
	process_t process,
	mach_port_t reply,
	data_t hostname,
	mach_msg_type_number_t hostnameCnt
);
#endif

/* SimpleRoutine proc_gethostname_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_gethostname_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_gethostname_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getprivports_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprivports_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_getprivports_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getallpids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getallpids_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_getallpids_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_setexecdata_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setexecdata_request
#if	defined(LINTLIBRARY)
    (process, reply, ports, portsPoly, portsCnt, ints, intsCnt)
	process_t process;
	mach_port_t reply;
	portarray_t ports;
	mach_msg_type_name_t portsPoly;
	mach_msg_type_number_t portsCnt;
	intarray_t ints;
	mach_msg_type_number_t intsCnt;
{ return proc_setexecdata_request(process, reply, ports, portsPoly, portsCnt, ints, intsCnt); }
#else
(
	process_t process,
	mach_port_t reply,
	portarray_t ports,
	mach_msg_type_name_t portsPoly,
	mach_msg_type_number_t portsCnt,
	intarray_t ints,
	mach_msg_type_number_t intsCnt
);
#endif

/* SimpleRoutine proc_getexecdata_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getexecdata_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_getexecdata_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_execdata_notify_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_execdata_notify_request
#if	defined(LINTLIBRARY)
    (process, reply, notify, notifyPoly)
	process_t process;
	mach_port_t reply;
	mach_port_t notify;
	mach_msg_type_name_t notifyPoly;
{ return proc_execdata_notify_request(process, reply, notify, notifyPoly); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t notify,
	mach_msg_type_name_t notifyPoly
);
#endif

/* SimpleRoutine proc_uname_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_uname_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_uname_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_register_version_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_register_version_request
#if	defined(LINTLIBRARY)
    (process, reply, credential, name, release, version)
	process_t process;
	mach_port_t reply;
	mach_port_t credential;
	string_t name;
	string_t release;
	string_t version;
{ return proc_register_version_request(process, reply, credential, name, release, version); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t credential,
	string_t name,
	string_t release,
	string_t version
);
#endif

/* SimpleRoutine proc_reauthenticate_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_reauthenticate_request
#if	defined(LINTLIBRARY)
    (process, reply, rendezvous2, rendezvous2Poly)
	process_t process;
	mach_port_t reply;
	mach_port_t rendezvous2;
	mach_msg_type_name_t rendezvous2Poly;
{ return proc_reauthenticate_request(process, reply, rendezvous2, rendezvous2Poly); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t rendezvous2,
	mach_msg_type_name_t rendezvous2Poly
);
#endif

/* SimpleRoutine proc_child_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_child_request
#if	defined(LINTLIBRARY)
    (process, reply, child)
	process_t process;
	mach_port_t reply;
	mach_port_t child;
{ return proc_child_request(process, reply, child); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t child
);
#endif

/* SimpleRoutine proc_setmsgport_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setmsgport_request
#if	defined(LINTLIBRARY)
    (process, reply, newmsgport)
	process_t process;
	mach_port_t reply;
	mach_port_t newmsgport;
{ return proc_setmsgport_request(process, reply, newmsgport); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t newmsgport
);
#endif

/* SimpleRoutine proc_reassign_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_reassign_request
#if	defined(LINTLIBRARY)
    (process, reply, newtask)
	process_t process;
	mach_port_t reply;
	mach_port_t newtask;
{ return proc_reassign_request(process, reply, newtask); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t newtask
);
#endif

/* SimpleRoutine proc_setowner_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setowner_request
#if	defined(LINTLIBRARY)
    (process, reply, owner, clear)
	process_t process;
	mach_port_t reply;
	uid_t owner;
	int clear;
{ return proc_setowner_request(process, reply, owner, clear); }
#else
(
	process_t process,
	mach_port_t reply,
	uid_t owner,
	int clear
);
#endif

/* SimpleRoutine proc_getpids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getpids_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_getpids_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_set_arg_locations_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_set_arg_locations_request
#if	defined(LINTLIBRARY)
    (process, reply, argv, envp)
	process_t process;
	mach_port_t reply;
	vm_address_t argv;
	vm_address_t envp;
{ return proc_set_arg_locations_request(process, reply, argv, envp); }
#else
(
	process_t process,
	mach_port_t reply,
	vm_address_t argv,
	vm_address_t envp
);
#endif

/* SimpleRoutine proc_get_arg_locations_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_get_arg_locations_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_get_arg_locations_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getmsgport_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getmsgport_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return proc_getmsgport_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_wait_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_wait_request
#if	defined(LINTLIBRARY)
    (process, reply, pid, options)
	process_t process;
	mach_port_t reply;
	pid_t pid;
	int options;
{ return proc_wait_request(process, reply, pid, options); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid,
	int options
);
#endif

/* SimpleRoutine proc_dostop_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_dostop_request
#if	defined(LINTLIBRARY)
    (process, reply, contthread)
	process_t process;
	mach_port_t reply;
	mach_port_t contthread;
{ return proc_dostop_request(process, reply, contthread); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t contthread
);
#endif

/* SimpleRoutine proc_handle_exceptions_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_handle_exceptions_request
#if	defined(LINTLIBRARY)
    (process, reply, msgport, forwardport, forwardportPoly, flavor, new_state, new_stateCnt)
	process_t process;
	mach_port_t reply;
	mach_port_t msgport;
	mach_port_t forwardport;
	mach_msg_type_name_t forwardportPoly;
	int flavor;
	thread_state_t new_state;
	mach_msg_type_number_t new_stateCnt;
{ return proc_handle_exceptions_request(process, reply, msgport, forwardport, forwardportPoly, flavor, new_state, new_stateCnt); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t msgport,
	mach_port_t forwardport,
	mach_msg_type_name_t forwardportPoly,
	int flavor,
	thread_state_t new_state,
	mach_msg_type_number_t new_stateCnt
);
#endif

/* SimpleRoutine proc_mark_stop_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_stop_request
#if	defined(LINTLIBRARY)
    (process, reply, signo, sigcode)
	process_t process;
	mach_port_t reply;
	int signo;
	int sigcode;
{ return proc_mark_stop_request(process, reply, signo, sigcode); }
#else
(
	process_t process,
	mach_port_t reply,
	int signo,
	int sigcode
);
#endif

/* SimpleRoutine proc_mark_cont_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_cont_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_mark_cont_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_mark_exit_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_exit_request
#if	defined(LINTLIBRARY)
    (process, reply, status, sigcode)
	process_t process;
	mach_port_t reply;
	int status;
	int sigcode;
{ return proc_mark_exit_request(process, reply, status, sigcode); }
#else
(
	process_t process,
	mach_port_t reply,
	int status,
	int sigcode
);
#endif

/* SimpleRoutine proc_mark_exec_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_exec_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_mark_exec_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_mark_traced_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mark_traced_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_mark_traced_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_mod_stopchild_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_mod_stopchild_request
#if	defined(LINTLIBRARY)
    (process, reply, doit)
	process_t process;
	mach_port_t reply;
	int doit;
{ return proc_mod_stopchild_request(process, reply, doit); }
#else
(
	process_t process,
	mach_port_t reply,
	int doit
);
#endif

/* SimpleRoutine proc_pid2task_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_pid2task_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return proc_pid2task_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_task2pid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_task2pid_request
#if	defined(LINTLIBRARY)
    (process, reply, task)
	process_t process;
	mach_port_t reply;
	mach_port_t task;
{ return proc_task2pid_request(process, reply, task); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t task
);
#endif

/* SimpleRoutine proc_task2proc_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_task2proc_request
#if	defined(LINTLIBRARY)
    (process, reply, task)
	process_t process;
	mach_port_t reply;
	mach_port_t task;
{ return proc_task2proc_request(process, reply, task); }
#else
(
	process_t process,
	mach_port_t reply,
	mach_port_t task
);
#endif

/* SimpleRoutine proc_proc2task_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_proc2task_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_proc2task_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_pid2proc_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_pid2proc_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return proc_pid2proc_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_getprocinfo_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprocinfo_request
#if	defined(LINTLIBRARY)
    (process, reply, which, flags)
	process_t process;
	mach_port_t reply;
	pid_t which;
	int flags;
{ return proc_getprocinfo_request(process, reply, which, flags); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t which,
	int flags
);
#endif

/* SimpleRoutine proc_getprocargs_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprocargs_request
#if	defined(LINTLIBRARY)
    (process, reply, which)
	process_t process;
	mach_port_t reply;
	pid_t which;
{ return proc_getprocargs_request(process, reply, which); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t which
);
#endif

/* SimpleRoutine proc_getprocenv_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getprocenv_request
#if	defined(LINTLIBRARY)
    (process, reply, which)
	process_t process;
	mach_port_t reply;
	pid_t which;
{ return proc_getprocenv_request(process, reply, which); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t which
);
#endif

/* SimpleRoutine proc_make_login_coll_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_make_login_coll_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_make_login_coll_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getloginid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getloginid_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return proc_getloginid_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_getloginpids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getloginpids_request
#if	defined(LINTLIBRARY)
    (process, reply, id)
	process_t process;
	mach_port_t reply;
	pid_t id;
{ return proc_getloginpids_request(process, reply, id); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t id
);
#endif

/* SimpleRoutine proc_setlogin_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setlogin_request
#if	defined(LINTLIBRARY)
    (process, reply, logname)
	process_t process;
	mach_port_t reply;
	string_t logname;
{ return proc_setlogin_request(process, reply, logname); }
#else
(
	process_t process,
	mach_port_t reply,
	string_t logname
);
#endif

/* SimpleRoutine proc_getlogin_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getlogin_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_getlogin_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_setsid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setsid_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_setsid_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_getsid_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getsid_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return proc_getsid_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_getsessionpgids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getsessionpgids_request
#if	defined(LINTLIBRARY)
    (process, reply, sid)
	process_t process;
	mach_port_t reply;
	pid_t sid;
{ return proc_getsessionpgids_request(process, reply, sid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t sid
);
#endif

/* SimpleRoutine proc_getsessionpids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getsessionpids_request
#if	defined(LINTLIBRARY)
    (process, reply, sid)
	process_t process;
	mach_port_t reply;
	pid_t sid;
{ return proc_getsessionpids_request(process, reply, sid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t sid
);
#endif

/* SimpleRoutine proc_getsidport_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getsidport_request
#if	defined(LINTLIBRARY)
    (process, reply)
	process_t process;
	mach_port_t reply;
{ return proc_getsidport_request(process, reply); }
#else
(
	process_t process,
	mach_port_t reply
);
#endif

/* SimpleRoutine proc_setpgrp_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_setpgrp_request
#if	defined(LINTLIBRARY)
    (process, reply, pid, pgrp)
	process_t process;
	mach_port_t reply;
	pid_t pid;
	pid_t pgrp;
{ return proc_setpgrp_request(process, reply, pid, pgrp); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid,
	pid_t pgrp
);
#endif

/* SimpleRoutine proc_getpgrp_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getpgrp_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return proc_getpgrp_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

/* SimpleRoutine proc_getpgrppids_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_getpgrppids_request
#if	defined(LINTLIBRARY)
    (process, reply, pgrp)
	process_t process;
	mach_port_t reply;
	pid_t pgrp;
{ return proc_getpgrppids_request(process, reply, pgrp); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pgrp
);
#endif

/* SimpleRoutine proc_get_tty_request */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_get_tty_request
#if	defined(LINTLIBRARY)
    (process, reply, pid)
	process_t process;
	mach_port_t reply;
	pid_t pid;
{ return proc_get_tty_request(process, reply, pid); }
#else
(
	process_t process,
	mach_port_t reply,
	pid_t pid
);
#endif

#endif	/* not defined(_process_user_) */
