/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package PollManager;
 
/**
 * A simple thread which waits a certain time in milliseconds defined by
 * <code>PollManager.timeOutTime</code> before closing communications.
 *
 * @version 0.5.6  4 June 2001
 * @author Jason Kitcat
 */
public class TimeOutThread extends Thread {

	public boolean threadStatus = true;

	public void stopThread() {
		threadStatus = false;
	}

	public void run() {
	
		while (threadStatus) {
		
			try {
				sleep(PollManager.timeOutTime);
			} catch (InterruptedException e) {}

			if (threadStatus) {
				PollManager.carryOn = false;
				PollManager.frame3.showError(PollManager.messages.getString("time_out"));
			}
				
		} //eof while
	
	} //EOF run()

	
} //EOF TimeOutThread