/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package PollManager;

import java.io.*;
import java.net.*;

import Free.util.*;

/**
 * TCPClient opens connections to servers and sends/receives all data.
 *
 * While TCPClient performs all the connection-level operations and deals
 * with errors, all data is passed to <code>PMProtocol</code> for
 * for processing.
 *
 * @version 0.12 8 September 2001
 * @author Jason Kitcat
 */
public class TCPClient implements Runnable {

	/**
	 * run() delivers a packet to the server whose DNS address is chosen.
	 * 
	 */
	public void run() {
	
		String serverName="";
		String packetMsg;
		int port = 0;
		Socket freeSocket = null;
		PrintWriter out = null;
		BufferedReader in = null;
		
		/* get data */
		if (PollManager.comms.getType()=='D') {
			serverName = PollManager.comms.ER_address;
			port = PollManager.comms.freePort;
		} else if (PollManager.comms.getType()=='P') {
			serverName = PollManager.comms.ER_address;
			port = PollManager.comms.freePort;
		} else if (PollManager.comms.getType()=='S') {
			serverName = PollManager.comms.ER_address;
			port = PollManager.comms.freePort;
		} else {
			PollManager.frame3.showInfo(PollManager.messages.getString("unrec_type"));
			PollManager.frame3.showError(PollManager.messages.getString("no_IO") + serverName);
		}
		
		packetMsg = PollManager.comms.getMessage() + "\r\n";
		
		/* send packet */
		try {
			freeSocket = new Socket(serverName, port); // open connection
			out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(freeSocket.getOutputStream())), true);
			in = new BufferedReader(new InputStreamReader(freeSocket.getInputStream()));
			
			out.println(packetMsg); // write packet
			
		} catch (UnknownHostException e) {
			PollManager.frame3.showError("Unknown host: " + serverName);
		} catch (IOException e) {
			PollManager.frame3.showError(PollManager.messages.getString("no_IO") + serverName);
		} catch (Exception e) {
			PollManager.frame3.showError(PollManager.messages.getString("err_connect") + e.getMessage());
		}
		
		String inputData = "NONE";
		String[] outputData = new String[] {" ","NONE"};
		
		/* read response */
		try {
			
			while (PollManager.carryOn) {
			
				if (in.ready()) {  // if there's data 
				
					inputData = in.readLine();
					
					if (!inputData.equals("")) { // check real data has arrived
		
						// decrypt data
						inputData = RSAEncrypt.blowDecrypt(PollManager.comms.getsession_key(), inputData);
						// now process
						outputData = PMProtocol.process(inputData);
						
						if ((outputData[1].equals("DONE"))|(outputData[1].equals("ERROR"))) {
						
							break;
							
						} else if (outputData[0].charAt(0)=='X') {
						
							out.println(outputData[1]);
							
							break;
							
						} else {
						
							out.println(outputData[1]);
							
						}
						
					}
					
				}
			
			}
						
			
		} catch (Exception e) {
			PollManager.frame3.showError(PollManager.messages.getString("connect_err") + e.getMessage());
		} finally {
			//tidy up
			try {
				out.close();
				in.close();
				freeSocket.close();
			} catch (Exception e) {
				PollManager.frame3.showError(PollManager.messages.getString("err_shut") + e.getMessage());
			}
			PollManager.comms.timer.stopThread();
			PollManager.comms.setFromServer(outputData[1]);
		}
		
	} //EOF run
	
} //EOF TCPClient