/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package PollManager;

import java.net.*;
import java.io.*;
import java.awt.*;
import java.util.*;

import Free.util.*;
import Free.awt.*;
/**
 * PollManager Class initialises and starts the PollManager software.
 *
 * @version 0.2 12 June 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class PollManager {

	/* Strings to store language details */
	protected static String language = "en";
	protected static String country = "GB";

	/* Time, in milliseconds, before a connection times out */
	protected static final long timeOutTime = 240000;

	/* variable for stopping comms after time out */
	protected static boolean carryOn = true;
	
	/* stores which language to run in */
	protected static Locale currentLocale;
	
	protected static ResourceBundle messages;

	/* stores user variables between frames */
	protected static String name = "";
	protected static String code = "";
	protected static String pword = "";
	protected static String voted = "";
	protected static String vote_where = "";

	protected static EnterFrame frame;
	protected static DetailFrame frame2;
	protected static StatusFrame frame3;
	protected static Comms comms;

	/**
	 * PollManager() is the constructor which creates all the AWT frames and
	 * launches the splash screen.
	 *
	 */
	protected PollManager()
	{
		try {
			// For native Look and Feel, uncomment the following code.
			/*
			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			} 
			catch (Exception e) { 
			}
			*/

			/* Internationalisation setup */
			currentLocale = new Locale(language, country);
		    messages = ResourceBundle.getBundle("PollManagerLang",currentLocale);
			
			/* AWT Frames setup */
			frame = new EnterFrame();

			FreePanel.showSplash(4000);
			RSAEncrypt.init();
			
			frame.initComponents();
			frame.setVisible(true);
			frame2 = new DetailFrame();
			frame2.initComponents();
			frame3 = new StatusFrame();
			frame3.initComponents();
			
			comms = new Comms();

		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	// Main entry point
	static public void main(String[] args) 
	{
		new PollManager();
	}
	
	/**
	 * Cleanup clears out variables prior to restarting management process.
	 */
	 protected static void cleanup() {
	 	name = "";
	 	code = "";
	 	pword = "";
	 	carryOn = true;
	 	voted = "";
	 	vote_where = "";
	 	
	 	try {
			frame.dispose();
			frame2.dispose();
			frame3.dispose();
			frame = new EnterFrame();
			frame.initComponents();
			frame.setVisible(true);
			frame2 = new DetailFrame();
			frame2.initComponents();
			frame3 = new StatusFrame();
			frame3.initComponents();
		} catch (Exception e) {
			e.printStackTrace();
		}
		//frame.jTextField1.setText("");
		//frame.jTextField2.setText("");
		//frame.jPasswordField1.setText("");
	 }
	
	/**
	 * checks String input to make sure it only contains safe characters.
	 * It's not pretty but regular expression packages tried all were far
	 * too slow.
	 * [Adapted from dbase one in servers]
	 *
	 * @param input  The String to check
	 * @returns  True if the string is ok
	 * @since 1.5
	 */
	 protected static boolean isSafe(String input) {
	 
	 	boolean ok = true;
	 	 
		for(int i = 0; (i<input.length())&&(ok==true); i++) {
	 
	 		switch (input.charAt(i)) {
	 			case 'a': ok = true; break;
	 			case 'b': ok = true; break;
	 			case 'c': ok = true; break;
	 			case 'd': ok = true; break;
	 			case 'e': ok = true; break;
	 			case 'f': ok = true; break;
	 			case 'g': ok = true; break;
	 			case 'h': ok = true; break;
	 			case 'i': ok = true; break;
	 			case 'j': ok = true; break;
	 			case 'k': ok = true; break;
	 			case 'l': ok = true; break;
	 			case 'm': ok = true; break;
	 			case 'n': ok = true; break;
	 			case 'o': ok = true; break;
	 			case 'p': ok = true; break;
	 			case 'q': ok = true; break;
	 			case 'r': ok = true; break;
	 			case 's': ok = true; break;
	 			case 't': ok = true; break;
	 			case 'u': ok = true; break;
	 			case 'v': ok = true; break;
	 			case 'w': ok = true; break;
	 			case 'x': ok = true; break;
	 			case 'y': ok = true; break;
	 			case 'z': ok = true; break;
	 			case 'A': ok = true; break;
	 			case 'B': ok = true; break;
	 			case 'C': ok = true; break;
	 			case 'D': ok = true; break;
	 			case 'E': ok = true; break;
	 			case 'F': ok = true; break;
	 			case 'G': ok = true; break;
	 			case 'H': ok = true; break;
	 			case 'I': ok = true; break;
	 			case 'J': ok = true; break;
	 			case 'K': ok = true; break;
	 			case 'L': ok = true; break;
	 			case 'M': ok = true; break;
	 			case 'N': ok = true; break;
	 			case 'O': ok = true; break;
	 			case 'P': ok = true; break;
	 			case 'Q': ok = true; break;
	 			case 'R': ok = true; break;
	 			case 'S': ok = true; break;
	 			case 'T': ok = true; break;
	 			case 'U': ok = true; break;
	 			case 'V': ok = true; break;
	 			case 'W': ok = true; break;
	 			case 'X': ok = true; break;
	 			case 'Y': ok = true; break;
	 			case 'Z': ok = true; break;
	 			case '1': ok = true; break;
	 			case '2': ok = true; break;
	 			case '3': ok = true; break;
	 			case '4': ok = true; break;
	 			case '5': ok = true; break;
	 			case '6': ok = true; break;
	 			case '7': ok = true; break;
	 			case '8': ok = true; break;
	 			case '9': ok = true; break;
	 			case '0': ok = true; break;
	 			case ';': ok = true; break;
	 			case ')': ok = true; break;
	 			case '(': ok = true; break;
	 			case '*': ok = true; break;
	 			case '\'': ok = true; break;
	 			case ' ': ok = true; break;
	 			case '=': ok = true; break;
	 			case '_': ok = true; break;
	 			case '+': ok = true; break;
	 			case '@': ok = true; break;
	 			case ',': ok = true; break;
	 			case '.': ok = true; break;
	 			case '<': ok = true; break;
	 			case '>': ok = true; break;
	 			case '?': ok = true; break;
	 			default:  ok = false; break;
	 		} //eof case
	 		
		 } //eof for
	 
	 	return ok;
	 
	 } //eof isSafe

} //EOF Class
