/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package PollManager;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

/**
 * The main voting screen where voters pick their choice and it is sent to a server.
 *
 * @version 0.7 4 June 2001
 * @author Jason Kitcat, Rajagopal C.V
 *
 */

public class DetailFrame extends Frame {

	ScrollPane jScrollPane1 = new ScrollPane();
    TextView tv;
	ScrollView sv;
	Font f;
	Font f2;
	TextStyle normal;
	TextStyle red;
	TextStyle blue;
	TextStyle green;
	String voteLocation;
	String voteStatus;
	Label jLabel1 = new Label();

	Button jButton1 = new Button();
	Label jLabel2 = new Label();
	Button jButton3 = new Button();
	Button jButton4 = new Button();

	public Insets getInsets(){ return new Insets(30, 10, 10, 10);}

	protected DetailFrame() {
	
		// prepare textView
		tv = new TextView(true);
        sv = new ScrollView(tv);
        f = new Font("Courier", Font.PLAIN, 12);
        f2 = new Font("Courier", Font.BOLD, 12);
        normal = new TextStyle(f, Color.black);
        red = new TextStyle(f2, Color.red);
        blue = new TextStyle(f, Color.blue);
        green = new TextStyle(f, Color.green);
        
		// build frame
		jLabel1.setText("");
		jLabel2.setText(PollManager.messages.getString("sure"));
		jButton1.setLabel(PollManager.messages.getString("yes_button"));
		jButton3.setLabel(PollManager.messages.getString("retry_button"));
		jButton4.setLabel(PollManager.messages.getString("cancel_button"));

		FreePanel buttonPane = new FreePanel();
		buttonPane.setSize(100, 50);
		
		FreePanel scrollPanel = new FreePanel(PollManager.messages.getString("vote_stat"));
		scrollPanel.setInsets(3, 3, 3, 3);
		scrollPanel.addComponent( 0, 0, 1, 4, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, sv);
		scrollPanel.setInsets(1, 0, 1, 0);
		scrollPanel.addComponent( 1, 0, 1, 4, 0, 0, GridBagConstraints.HORIZONTAL, 
			1.0f, 0.0f, buttonPane);
		scrollPanel.setInsets(3, 3, 3, 3);
		scrollPanel.addComponent( 2, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton1);
		scrollPanel.addComponent( 2, 2, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton3);
		scrollPanel.addComponent( 2, 3, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton4);

		add(scrollPanel);
		setTitle(PollManager.messages.getString("vote_title"));
		setSize(new java.awt.Dimension(460, 300));

	} //eof VoteFrame()

	class focusListener extends FocusAdapter {

		Color t_col = getBackground();

		public void focusGained( FocusEvent e){
				((Checkbox)e.getSource()).setBackground(Color.gray);
		}

		public void focusLost( FocusEvent e){
				((Checkbox)e.getSource()).setBackground(t_col);
		}

	} // eof focusListener

	
	public void initComponents() throws Exception {

		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});

		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton3ActionPerformed(e);
			}
		});

		jButton4.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton4ActionPerformed(e);
			}
		});

		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
		
		jButton1.setEnabled(true);
		jButton3.setEnabled(false);
		jButton4.setEnabled(true);
		jLabel2.setVisible(false);

	} //eof initComponents()
	


	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		showMsg(msg);
	}

	// Show an warning message (red, bold text)
	protected void showError(String msg) {
		msg += "\n";
		tv.append(msg, red);
	}

	// Show a text message using the specified AttributeSet

	protected void showMsg(String msg) {
		msg += "\n";
		tv.append(msg, normal);
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)

	{

	}

	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
		jLabel2.setVisible(false);
		jButton1.setEnabled(false);
		showInfo(PollManager.messages.getString("vote_send"));
		PollManager.comms.sendPMVoted(PollManager.name, PollManager.code, PollManager.pword);
	}

	protected void jButton3ActionPerformed(java.awt.event.ActionEvent e) {
		jButton3.setEnabled(false);
		jButton4.setEnabled(false);
		jButton1.setEnabled(false);
		PollManager.comms.sendDiag("test");
		showInfo(PollManager.messages.getString("vote_send2"));
	}
	
	protected void jButton4ActionPerformed(java.awt.event.ActionEvent e) {
		setVisible(false);
		PollManager.cleanup();
		PollManager.frame.setVisible(true);
	}
	
	protected void voteOK() {	
		jButton1.setEnabled(false);
		jButton4.setEnabled(true);
		jButton4.setEnabled(true);
		showInfo(PollManager.messages.getString("vote_reg"));
	}
	
	protected void voteErr() {
		jButton1.setEnabled(false);
		jButton3.setEnabled(true);
		jButton4.setEnabled(true);
		showError(PollManager.messages.getString("vote_sorry"));
	}

	protected void loadUser() {
	
		switch (PollManager.vote_where.charAt(0)) {
			case 'I': voteLocation = "Internet Voter"; break;
			case 'M': voteLocation = "Postal Voter"; break;
			case 'P': voteLocation = "Polling Station Voter"; break;
			case 'O': voteLocation = "Other Voter"; break;
		}
		switch (PollManager.voted.charAt(0)) {
			case 'F': voteStatus = "Not Voted"; break;
			case 'C': voteStatus = "Logged in before/Not Voted"; break;
			case 'T': voteStatus = "VOTED"; break;
		}

		showInfo(PollManager.name+":"+PollManager.code+":"+voteLocation+":"+voteStatus);
		
	}

	public static void main( String args[]) throws Exception{
		DetailFrame v = new DetailFrame();
		v.initComponents();
		v.setVisible(true);
	}


} //EOF Class

