/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
/**
 * TCPClient Class
 * @version 0.7 23 June 2001
 * @author Jason Kitcat
 */
 
package FreeTest;

import java.io.*;
import java.net.*;

public class TCPClient implements Runnable {

	String packetMsg;
	
	/* constructor */
	public TCPClient(int i) {
		if (FTest.comms.isStress) {
			packetMsg = FTest.frame.stressVector.elementAt(i) + "\r\n";
		} else {
			packetMsg = FTest.comms.getMessage() + "\r\n";
		}
	}

	/**
	 * run() delivers a packet to the server whose DNS address is chosen
	 * 
	 */
	public void run() {
	
		String serverName;
		int port;
		Socket freeSocket = null;
		PrintWriter out = null;
		BufferedReader in = null;
		
		/* get data */
		if (FTest.comms.getType()=='V') {
			serverName = FTest.comms.R_address;
		} else if (FTest.comms.getType()=='D') {
			serverName = FTest.comms.R_address;
		} else if (FTest.comms.getType()=='E') {
			serverName = FTest.comms.ER_address;
		} else if (FTest.comms.getType()=='K') {
			serverName = FTest.comms.ER_address;
		} else {
			FTest.frame.showInfo("Other type");
			serverName = FTest.comms.ER_address;
		}
		
		port = FTest.comms.freePort;
		
		/* send packet */
		try {
			freeSocket = new Socket(serverName, port);
			out = new PrintWriter(freeSocket.getOutputStream(), true);
			in = new BufferedReader(new InputStreamReader(freeSocket.getInputStream()));
			FTest.frame.showInfo("Sending: " + packetMsg);
			out.println(packetMsg); //write packet
		} catch (UnknownHostException e) {
			FTest.frame.showError("Unknown host: " + serverName);
		} catch (IOException e) {
			FTest.frame.showError("Couldn't get I/O for the connection to: " + serverName);
		}
		
		String inputData = "NONE";
		String outputData = "NONE";
		
		/* read response */
		try {
			
			while (true) {
			
				if (in.ready()) {  // if there's data 
				
					inputData = in.readLine();
					
					if (!inputData.equals("")) { // check real data has arrived
						// decrypt data
						inputData = RSAEncrypt.blowDecrypt(FTest.comms.getsession_key(), inputData);
						// now process
						outputData = ClientProtocol.process(inputData);
						
						if ((outputData.equals("DONE"))|(outputData.equals("ERROR"))) {
						
							break;
							
						} else if (outputData.charAt(0)=='X') {
						
							out.println(outputData);
							
							break;
							
						} else {
						
							out.println(outputData);
							
						}
						
					}
					
				}
			
			}
						
			
		} catch (Exception e) {
			FTest.frame.showError("Connection Error: " + e.getMessage());
		} finally {
			//tidy up
			try {
				out.close();
				in.close();
				freeSocket.close();
			} catch (Exception e) {
				FTest.frame.showError("Error shutting connection: " + e.getMessage());
			}
			FTest.comms.setFromServer(outputData);
		}			
	
	} //EOF run
	
} //EOF TCPClient

