/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package FreeTest;


/**
 * Because all FREE communications (like HTTP) must be ASCII we can create some
 * String <-> Byte conversion tools that bypass the massive performance hit of 
 * dealing with all Unicode characters. This class is based on code from "Java
 * Performance and Scalbility. Volume 1" by Dov Bulka where figures indicate a
 * factor of 6.8 perfomance improvement by using these methods.
 *
 * @version 0.1 7 February 2001
 * @author Jason Kitcat
 * @since 1.5
 */
public class StringByteTools {

	/**
	 * This method converts a String to bytes.
	 * Only if the String is pure ASCII
	 *
	 * @param buf String to be converted
	 * @returns A byte array
	 */
	public static byte[] asciiGetBytes(String buf) {
		int size = buf.length();
		int i;
		byte[] bytebuf = new byte[size];
		
		for (i = 0; i < size; i++) {
			bytebuf[i] = (byte) buf.charAt(i);
		}
		
		return bytebuf;
		
	}
	
	
	/**
	 * This method converts bytes to a String.
	 * Only if the byte array represents pure ASCII
	 *
	 * @param buf Bytes to be converted
	 * @returns A String
	 */
	public static String asciiGetString(byte[] buf) {
	
		String s = new String(buf,0);
		
		return s;
	
	}

} //eof class
