/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
/**
 * Packet Class - customised data type
 * @version 0.4 23 June 2001
 * @author Jason Kitcat
 */
 
package FreeTest;

import java.lang.*;

public class Packet {


private char type;
private String message;
private String digest;

/* constructor */
protected Packet(String p) {

	int i=2;

	type = p.charAt(0);
	while (p.charAt(i)!='|') {
		i++;
	}
	
	// defensive code
	if (i == 2) {
		message = "";
	} else {
		message = p.substring(2,(i));
	}
	digest = p.substring(i+1);

}

/* returns a printable value of Packet */
public String toString() {

	String out;
	
	out = type + "|" + message + "|" + digest;
	
	return out;
	
}

/* return data portion of Packet */
protected String getMessage() {

	return message;
	
}

/** return the portion of Packet used in MAC */
public String getMACMessage() {

	String temp =  type + "|" + message;
	return temp;
	
}

/* return message digest of Packet */
protected String getDigest() {

	return digest;
	
}

/* return type of Packet */
protected char getType() {

	return type;
	
}

} //EOF Packet