/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
/**
 * TestProtocol Class
 * @version 0.5  23 June 2001
 * @author Jason Kitcat
 */
 
package FreeTest;
 
import java.util.*;

public class ClientProtocol {

	/**
	 * process analyses packets and responds appropriately
	 *
	 * @param inputData   Contains the contents of a received packet
	 * @returns   String with a packet to return to client
	 */
	protected static String process(String inputData) throws Exception {

		String outputData="";
		
		if (inputData.charAt(0) == 'A') {
			/* auth request */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check
			
				if (p.getMessage().charAt(0)=='T') {
					FTest.frame.showInfo("User authorised to vote!");
				} else {
					FTest.frame.showError("User authorisation failed.");
				}
				
				outputData = RSAEncrypt.pubEncrypt(FTest.comms.er_public_key,FTest.comms.getsession_key()) + "-" + RSAEncrypt.blowEncrypt(FTest.comms.getsession_key(),"X|OK|" + AuthSys.makeDigest("X|OK")) + "\r\n";			

				if (FTest.comms.isStress) { // profiling for stress tests
					FTest.comms.doneStress();
				}
				
			} else {
				outputData = "ERROR";
				FTest.frame.showError("Packet corrupted or altered!");
			}
			

		} else if (inputData.charAt(0) == 'C') {
			/* confirm */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check

				if (p.getMessage().equals("STAMP")) {
					if (FTest.comms.getCheck() != null) {
						String data = FTest.comms.checkStack.elementAt(0).toString();
						FTest.comms.checkStack.removeElementAt(0);
						FTest.frame.showInfo(data);
						outputData = RSAEncrypt.pubEncrypt(FTest.comms.rt_public_key,FTest.comms.getsession_key()) + "-" + RSAEncrypt.blowEncrypt(FTest.comms.getsession_key(),"C|" + data + "|" + AuthSys.makeDigest("C|" + data)) + "\r\n"; //reply with time stamp
						FTest.frame.showInfo("Time Stamp check sent.");		
					} else {
						FTest.frame.showError("Vote security error.");
						outputData = "ERROR";
					}
				} else if (p.getMessage().equals("OK")) {  //everything went fine
					FTest.frame.showInfo("Vote confirmed.");
					outputData = RSAEncrypt.pubEncrypt(FTest.comms.rt_public_key,FTest.comms.getsession_key()) + "-" + RSAEncrypt.blowEncrypt(FTest.comms.getsession_key(),"X|OK|" + AuthSys.makeDigest("X|OK")) + "\r\n";
					
					if (FTest.comms.isStress) { // profiling for stress tests
						FTest.comms.doneStress();
					}
					
				} else {
					FTest.frame.showError("Unrecognized confirm packet received.");
					outputData = "ERROR";
				}
			} else {
				outputData = "ERROR";
				throw new Exception("Packet corrupted or altered!");
			}			
							
		} else if (inputData.charAt(0) == 'D') {
			/* diagnostic */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check

				FTest.frame.showInfo("Diagnostic packet received.");
				outputData = "X|OK|" + AuthSys.makeDigest("X|OK") + "\r\n";
			
			} else {
				outputData = "ERROR";
				throw new Exception("Packet corrupted or altered!");
			}

		} else if (inputData.charAt(0) == 'K') {
			/* AuthKey packet */
			Packet p = new Packet(inputData);

			if (AuthSys.checkDigest(p)) {  // tamper check
				FTest.frame.showInfo("AuthKey packet received: " + p.getMessage());
				outputData = RSAEncrypt.pubEncrypt(FTest.comms.er_public_key,FTest.comms.getsession_key()) + "-" + RSAEncrypt.blowEncrypt(FTest.comms.getsession_key(),"X|OK|" + AuthSys.makeDigest("X|OK")) + "\r\n";
			} else {
				outputData = "ERROR";
				throw new Exception("Packet corrupted or altered!");
			}

		} else {
			outputData = "ERROR";
			FTest.frame.showError("Unrecognized packet received.");
		}
		
		return outputData;

	} //EOF process()

} //EOF Class