/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package FreeInstall;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

/**
 * The main FreeInstall status screen.
 *
 * @version 0.6 2 April 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class StatusFrame extends Frame 
{

	
    TextView tv;
	ScrollView sv;
	Font f;
	Font f2;
	TextStyle normal;
	TextStyle red;
	TextStyle blue;
	TextStyle green;
	Button jButton1 = new Button();

	public Insets getInsets(){ return new Insets(30, 10, 10, 10);}

	protected StatusFrame() {
	
		// prepare textView
		tv = new TextView(true);
        sv = new ScrollView(tv);
        f = new Font("Courier", Font.PLAIN, 12);
        f2 = new Font("Courier", Font.BOLD, 12);
        normal = new TextStyle(f, Color.black);
        red = new TextStyle(f2, Color.red);
        blue = new TextStyle(f, Color.blue);
        green = new TextStyle(f, Color.green);
        
		// build frame
		jButton1.setLabel("Quit");
		
		FreePanel scrollPanel = new FreePanel("Installation in Progress");
		

		scrollPanel.setInsets(3, 3, 3, 3);
		add( scrollPanel);	
		
		scrollPanel.addComponent( 0, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, sv);
			
		scrollPanel.addComponent( 1, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton1);
			
		setTitle("GNU.FREE: Installation progress");
		setSize(new java.awt.Dimension(500, 260));
	
	}

	public void initComponents() throws Exception
	{
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}
 
	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		showMsg(msg);
	}
  
	// Show an warning message (red, bold text)
	protected void showError(String msg) {
		msg += "\n";
		tv.append(msg, red);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg(String msg) {
		msg += "\n";
		tv.append(msg, normal);
	}

 	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{		
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
		setVisible(false);
		dispose();
		System.exit(0);
	}

	public static void main( String args[]){
		StatusFrame frame4 = new StatusFrame();
		frame4.setVisible(true);
		try{
			frame4.initComponents();
		}catch(Exception e){}
	}
	
}
