/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package FreeInstall;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

/**
 * Asks user to specify file name of XML config file
 *
 * @version 0.1 1 December 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class FileFrame extends Frame {

	Label jLabel1 = new Label();
	TextField jTextField1 = new TextField();
	Button jButton1 = new Button();

	public Insets getInsets() {

		return new Insets( 30, 10, 10, 10);
	}

	protected FileFrame() {

		setTitle("GNU.FREE: Install");
		jButton1.setLabel("OK");
		jLabel1.setText("Please enter the name of your config file e.g. example.xml");
		
		FreePanel scrollPanel = new FreePanel("GNU.FREE: Config file");
		scrollPanel.setInsets(3, 3, 3, 3);
		
		scrollPanel.addComponent( 1, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, jLabel1);
		scrollPanel.addComponent( 2, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jTextField1);
		scrollPanel.addComponent( 3, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton1);
			
		add(scrollPanel, BorderLayout.CENTER);
		setSize(new java.awt.Dimension(400, 175));

	}

	public void initComponents() throws Exception {

		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
	}

	public void jButton1ActionPerformed(java.awt.event.ActionEvent e) {

		String input = new String(jTextField1.getText());

		if (!input.equals("")) {
			try {
				Install.config_filename=input;
				setVisible(false);
				Install.frame2.setVisible(true);

				dispose();
			} catch (Exception ex) { // bail out as it's too early to deal with
				setVisible(false);
				dispose();
				System.exit(1);
			}
		}
		
	}
	
} //EOF Class
