/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeInstall;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

 /**
  * A screen to let users easily set the GNU.FREE code variables.
  *
  * @version 0.1 9 April 2001
  * @author Jason Kitcat, Rajagopal C.V
  */
public class ERDBFrame extends Frame {

	Label jLabel1 = new Label();
	Label jLabel2 = new Label();
	Label jLabel3 = new Label();
	Label jLabel4 = new Label();
	Label jLabel6 = new Label();
	Label jLabel7 = new Label();
	TextField jTextField1 = new TextField();
	TextField jTextField2 = new TextField();
	TextField jTextField3 = new TextField();
	TextField jTextField4 = new TextField();
	Button jButton1 = new Button();
	Label jLabel5 = new Label();

	public Insets getInsets(){ return new Insets(30, 10, 10, 10);}

	protected ERDBFrame() {
	
		jLabel4.setText("Please fill out fields for setup:");
		jLabel1.setText("ER Database username:");
		jLabel2.setText("ER Database password:");
		jLabel3.setText("ER Database name:");
		jLabel7.setText("ER Database server name:");
		jLabel5.setText("Please fill out ALL the fields!");
		jButton1.setLabel("OK");
	
		FreePanel scrollPanel = new FreePanel("ER Database Setup");
		scrollPanel.setInsets(3, 3, 3, 3);
		
		scrollPanel.addComponent( 0, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel4);
		scrollPanel.addComponent( 1, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel1);
		scrollPanel.addComponent( 2, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jTextField1);
		scrollPanel.addComponent( 3, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel2);
		scrollPanel.addComponent( 4, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jTextField2);
		scrollPanel.addComponent( 5, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel3);
		scrollPanel.addComponent( 6, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jTextField3);
		scrollPanel.addComponent( 7, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel7);
		scrollPanel.addComponent( 8, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jTextField4);
		scrollPanel.addComponent( 9, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel5);
		scrollPanel.addComponent( 9, 1, 1, 1, 0, 0, GridBagConstraints.NONE, 
			1.0f, 0.0f, jButton1);
			
		add(scrollPanel);
		setTitle("GNU.FREE: Setup (5a)");
		setResizable(true);
		setSize(new java.awt.Dimension(320, 380));
		
	}

	protected void initComponents() throws Exception
	{

		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}

 	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
	}
	
	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {

		if (jTextField1.getText().equals("")|jTextField2.getText().equals("")|jTextField3.getText().equals("")|jTextField4.getText().equals("")) {
			jLabel5.setVisible(true);
		} else {
			if (Install.isSafe(jTextField1.getText())|Install.isSafe(jTextField2.getText())|Install.isSafe(jTextField3.getText())|Install.isSafe(jTextField4.getText())) {
				setVisible(false);
				jLabel5.setVisible(false);
			
				Install.er_dbuser = jTextField1.getText();
				Install.er_dbpass = jTextField2.getText();
				Install.er_dbname = jTextField3.getText();
				Install.er_dbhostname = jTextField4.getText();

				if (Install.rt_dbtype!=3) {
					setVisible(false);			
					Install.frame8.setVisible(true);
					dispose();
				} else {
					// no need to set up DBs so install
					setVisible(false);			
					Install.frame.setVisible(true);
					Install.doInstallation();		
					dispose();
				}
			} else {
				jLabel5.setVisible(true);
			}
		}
		
}
			
} //EOF class
