/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeInstall;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

 /**
  * A screen to let users easily set the GNU.FREE code variables.
  *
  * @version 0.1 9 April 2001
  * @author Jason Kitcat, Rajagopal C.V
  */
public class DBChoiceFrame extends Frame {

	private final CheckboxGroup group = new CheckboxGroup();
	private final CheckboxGroup group2 = new CheckboxGroup();

	Checkbox jRadioButton1;
	Checkbox jRadioButton2;
	Checkbox jRadioButton3;
	Checkbox jRadioButton21;
	Checkbox jRadioButton22;
	Checkbox jRadioButton23;
	Label jLabel1 = new Label();
	Label jLabel2 = new Label();
	Button jButton1 = new Button();

	public Insets getInsets(){ return new Insets(30, 10, 10, 10);}

	protected DBChoiceFrame() {
	
		setTitle("GNU.FREE: Setup (5)");
		jRadioButton1 = new Checkbox("Hypersonic SQL [built-in default]", group, true);
		jRadioButton2 = new Checkbox("MySQL", group, false);
		jRadioButton3 = new Checkbox("PostgeSQL", group, false);
		jRadioButton21 = new Checkbox("Hypersonic SQL [built-in default]", group2, true);
		jRadioButton22 = new Checkbox("MySQL", group2, false);
		jRadioButton23 = new Checkbox("PostgeSQL", group2, false);
		jButton1.setLabel("OK");
		jLabel1.setText("What kind of database for RTServer?");
		jLabel2.setText("What kind of database for ERServer?");
		
		FreePanel scrollPanel = new FreePanel("Databases");
		scrollPanel.setInsets(3, 3, 3, 3);
		
		scrollPanel.addComponent( 1, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, jLabel1);
		scrollPanel.addComponent( 2, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jRadioButton1);
		scrollPanel.addComponent( 3, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jRadioButton2);
		scrollPanel.addComponent( 4, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jRadioButton3);
		scrollPanel.addComponent( 5, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, jLabel2);
		scrollPanel.addComponent( 6, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jRadioButton21);
		scrollPanel.addComponent( 7, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jRadioButton22);
		scrollPanel.addComponent( 8, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jRadioButton23);
		scrollPanel.addComponent( 9, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton1);
			
		add(scrollPanel, BorderLayout.CENTER);
		setSize(new java.awt.Dimension(425, 375));

	}

	class itemListener implements ItemListener{
		public void itemStateChanged(ItemEvent e){
			if(e.getSource() == jRadioButton1){
				jRadioButton1StateChanged(e);
			}
			else if(e.getSource() == jRadioButton2){

				jRadioButton2StateChanged(e);
			}
			else if(e.getSource() == jRadioButton3){

				jRadioButton3StateChanged(e);
			}
			if(e.getSource() == jRadioButton21){
				jRadioButton21StateChanged(e);
			}
			else if(e.getSource() == jRadioButton22){

				jRadioButton22StateChanged(e);
			}
			else if(e.getSource() == jRadioButton23){

				jRadioButton23StateChanged(e);
			}
		}

	}
	
	protected void initComponents() throws Exception
	{

		jRadioButton1.addItemListener(new itemListener());
		jRadioButton2.addItemListener(new itemListener());
		jRadioButton3.addItemListener(new itemListener());
		jRadioButton21.addItemListener(new itemListener());
		jRadioButton22.addItemListener(new itemListener());
		jRadioButton23.addItemListener(new itemListener());
		
		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}

 	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
	}
	
	public void jRadioButton1StateChanged(ItemEvent e) {
		Install.rt_dbtype = 3; // HSQL
	}

	public void jRadioButton2StateChanged(ItemEvent e) {
		Install.rt_dbtype = 1; // MySQL
	}

	public void jRadioButton3StateChanged(ItemEvent e) {
		Install.rt_dbtype = 2; // PostgreSQL
	}

	public void jRadioButton21StateChanged(ItemEvent e) {
		Install.er_dbtype = 3; // HSQL
	}

	public void jRadioButton22StateChanged(ItemEvent e) {
		Install.er_dbtype = 1; // MySQL
	}

	public void jRadioButton23StateChanged(ItemEvent e) {
		Install.er_dbtype = 2; // PostgreSQL
	}
	
	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
		if (Install.er_dbtype!=3) {
			setVisible(false);			
			Install.frame7.setVisible(true);
			dispose();
		} else if (Install.rt_dbtype!=3) {
			setVisible(false);			
			Install.frame8.setVisible(true);
			dispose();
		} else {
			// no need to set up DBs so install
			setVisible(false);			
			Install.frame.setVisible(true);
			Install.doInstallation();		
			dispose();
		}
	}
			
} //EOF class
