/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeClient;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

/**
 * The main voting screen where voters pick their choice and it is sent to a server.
 *
 * @version 0.8 30 October 2001
 * @author Jason Kitcat, Rajagopal C.V
 *
 */

public class VoteFrame extends Frame {

	private String choice;
	private final CheckboxGroup group = new CheckboxGroup();
	
	/* candidate codes and long names */
//#ifdef INSTALL
	private final String cand1name = "Labour Party";
//#ifdef INSTALL
	private final String cand1code = "LABOUR";
//#ifdef INSTALL
	private final String cand2name = "Conservative Party";
//#ifdef INSTALL
	private final String cand2code = "TORY";
//#ifdef INSTALL
	private final String cand3name = "Liberal Democrats";
//#ifdef INSTALL
	private final String cand3code = "LIBDEM";
//#ifdef INSTALL
	private final String cand4name = "Green Party";
//#ifdef INSTALL
	private final String cand4code = "GREEN";

	ScrollPane jScrollPane1 = new ScrollPane();
    TextView tv;
	ScrollView sv;
	Font f;
	Font f2;
	TextStyle normal;
	TextStyle red;
	TextStyle blue;
	TextStyle green;
	boolean clicked;
	Label jLabel1 = new Label();

	Button jButton1 = new Button();
	Button jButton2 = new Button();
	Label jLabel2 = new Label();
	Button jButton3 = new Button();
	Button jButton4 = new Button();

	/* vote system specific vars */
	Checkbox jToggleButton1 = new Checkbox(); // fptp-default
	Checkbox jToggleButton2 = new Checkbox();
	Checkbox jToggleButton3 = new Checkbox();
	Checkbox jToggleButton4 = new Checkbox();
	TextField jTextField1 = new TextField(); // borda-default
	TextField jTextField2 = new TextField();
	TextField jTextField3 = new TextField();
	TextField jTextField4 = new TextField();
	Label bordaLabel1 = new Label();
	Label bordaLabel2 = new Label();
	Label bordaLabel3 = new Label();
	Label bordaLabel4 = new Label();

	public Insets getInsets(){ return new Insets(30, 10, 10, 10);}

	protected VoteFrame() {
		
		int FrameHeight = 0;
	
		// prepare textView
		tv = new TextView(true);
        sv = new ScrollView(tv);
        f = new Font("Courier", Font.PLAIN, 12);
        f2 = new Font("Courier", Font.BOLD, 12);
        normal = new TextStyle(f, Color.black);
        red = new TextStyle(f2, Color.red);
        blue = new TextStyle(f, Color.blue);
        green = new TextStyle(f, Color.green);
        
		jLabel1.setText(FClient.messages.getString("make_choice"));
		FreePanel buttonPane = new FreePanel();
		choice = "";
		
		if (FClient.vote_system.equals("fptp-default")) {  // First Past the Post default init code
		
			// build frame
			jToggleButton1.setCheckboxGroup(group);
			jToggleButton2.setCheckboxGroup(group);
			jToggleButton3.setCheckboxGroup(group);
			jToggleButton4.setCheckboxGroup(group);

			jToggleButton1.setLabel(cand1name);
			jToggleButton2.setLabel(cand2name);
			jToggleButton3.setLabel(cand3name);
			jToggleButton4.setLabel(cand4name);
			
			buttonPane.setSize(100, 50);
			buttonPane.addComponent( 0, 0, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, jToggleButton1);
			buttonPane.addComponent( 0, 1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, jToggleButton2);
			buttonPane.addComponent( 0, 2, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, jToggleButton3);
			buttonPane.addComponent( 0, 3, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, jToggleButton4);
				
			FrameHeight = 300;
		
		} else if (FClient.vote_system.equals("borda-default")) { // Borda default init code
			
			clicked = false;
			
			bordaLabel1.setText(cand1name);
			bordaLabel2.setText(cand2name);
			bordaLabel3.setText(cand3name);
			bordaLabel4.setText(cand4name);
			
			jTextField1.setColumns(5);
			jTextField2.setColumns(5);
			jTextField3.setColumns(5);
			jTextField4.setColumns(5);
			
			buttonPane.setSize(100, 100);
			buttonPane.addComponent( 0, 0, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, bordaLabel1);
			buttonPane.addComponent( 0, 1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, bordaLabel2);
			buttonPane.addComponent( 0, 2, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, bordaLabel3);
			buttonPane.addComponent( 0, 3, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, bordaLabel4);
			buttonPane.addComponent( 1, 0, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, jTextField1);
			buttonPane.addComponent( 1, 1, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, jTextField2);
			buttonPane.addComponent( 1, 2, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, jTextField3);
			buttonPane.addComponent( 1, 3, 1, 1, 0, 0, GridBagConstraints.HORIZONTAL, 
				1.0f, 0.0f, jTextField4);
				
			FrameHeight = 400;
				
		} else {
			System.out.println("FATAL ERROR: unrecognised vote system defined.");
		} // EOF Vote_System if

		jLabel2.setText(FClient.messages.getString("sure"));
		jButton1.setLabel(FClient.messages.getString("yes_button"));
		jButton2.setLabel(FClient.messages.getString("no_button"));

		jButton3.setLabel(FClient.messages.getString("retry_button"));
		jButton4.setLabel(FClient.messages.getString("quit_button"));

		FreePanel scrollPanel = new FreePanel(FClient.messages.getString("vote_stat"));
		scrollPanel.setInsets(3, 3, 3, 3);
		scrollPanel.addComponent( 0, 0, 1, 4, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, sv);
		scrollPanel.setInsets(1, 0, 1, 0);
		scrollPanel.addComponent( 1, 0, 1, 4, 0, 0, GridBagConstraints.HORIZONTAL, 
			1.0f, 0.0f, buttonPane);
		scrollPanel.setInsets(3, 3, 3, 3);
		scrollPanel.addComponent( 2, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton1);
		scrollPanel.addComponent( 2, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton2);
		scrollPanel.addComponent( 2, 2, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton3);
		scrollPanel.addComponent( 2, 3, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton4);

		add(scrollPanel);
		setTitle(FClient.messages.getString("vote_title"));
		setSize(new java.awt.Dimension(460, FrameHeight));

	} //eof VoteFrame()

	class focusListener extends FocusAdapter {

		Color t_col = getBackground();

		public void focusGained( FocusEvent e){
				((Checkbox)e.getSource()).setBackground(Color.gray);
		}

		public void focusLost( FocusEvent e){
				((Checkbox)e.getSource()).setBackground(t_col);
		}

	} // eof focusListener

	

	class itemListener implements ItemListener{

		public void itemStateChanged(ItemEvent e){

			if(e.getSource() == jToggleButton1){
				jToggleButton1StateChanged(e);
			} else if(e.getSource() == jToggleButton2){
				jToggleButton2StateChanged(e);
			} else if(e.getSource() == jToggleButton3){
				jToggleButton3StateChanged(e);
			} else if(e.getSource() == jToggleButton4){
				jToggleButton4StateChanged(e);
			}
		}
	} //eof itemListener

	public void initComponents() throws Exception {
	
		if (FClient.vote_system.equals("fptp-default")) {  // First Past the Post default init code
			jToggleButton1.addItemListener(new itemListener());
			jToggleButton1.addFocusListener(new focusListener());
			jToggleButton2.addItemListener(new itemListener());
			jToggleButton2.addFocusListener(new focusListener());
			jToggleButton3.addItemListener(new itemListener());
			jToggleButton3.addFocusListener(new focusListener());
			jToggleButton4.addItemListener(new itemListener());
			jToggleButton4.addFocusListener(new focusListener());
			
			jButton1.setEnabled(false);
			jButton2.setEnabled(false);
			jButton3.setEnabled(false);
			jButton4.setEnabled(true);
			jLabel2.setVisible(false);

		} else if (FClient.vote_system.equals("borda-default")) { // Borda default init code
			jButton1.setEnabled(true);
			jButton2.setEnabled(false);
			jButton3.setEnabled(false);
			jButton4.setEnabled(true);
			jLabel2.setVisible(false);
		}

		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});

		jButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton2ActionPerformed(e);
			}
		});

		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton3ActionPerformed(e);
			}
		});

		jButton4.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton4ActionPerformed(e);
			}
		});

		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
		
	} //eof initComponents()
	


	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		showMsg(msg);
	}

	// Show an warning message (red, bold text)
	protected void showError(String msg) {
		msg += "\n";
		tv.append(msg, red);
	}

	// Show a text message using the specified AttributeSet

	protected void showMsg(String msg) {
		msg += "\n";
		tv.append(msg, normal);
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)

	{

	}
	
	/**
	 * If <code>FClient.number_of_choices</code> is 4 then bordaSum
	 * returns 10 as it does (1+2+3+4) = 10
	 */
	private int bordaSum() {
	
		int res=0;
	
		for (int x = 1; x <= FClient.number_of_choices; x++) {
			res += x;
		}
		
		return res;
		
	} //EOF bordaSum
	
	protected void jToggleButton1StateChanged(ItemEvent e) {
		choice = cand1code;
		jLabel2.setVisible(true);
		showInfo(FClient.messages.getString("sure"));
		jButton1.setEnabled(true);
		jButton2.setEnabled(true);
	}

	protected void jToggleButton2StateChanged(ItemEvent e) {
		choice = cand2code;
		jLabel2.setVisible(true);
		showInfo(FClient.messages.getString("sure"));
		jButton1.setEnabled(true);
		jButton2.setEnabled(true);
	}

	protected void jToggleButton3StateChanged(ItemEvent e) {
		choice = cand3code;
		jLabel2.setVisible(true);
		showInfo(FClient.messages.getString("sure"));
		jButton1.setEnabled(true);
		jButton2.setEnabled(true);
	}

	protected void jToggleButton4StateChanged(ItemEvent e) {
		choice = cand4code;
		jLabel2.setVisible(true);
		showInfo(FClient.messages.getString("sure"));
		jButton1.setEnabled(true);
		jButton2.setEnabled(true);
	}

	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
		if (FClient.vote_system.equals("fptp-default")) { // FPTP default code
			jLabel2.setVisible(false); // update interface & send vote
			jButton1.setEnabled(false);
			jButton2.setEnabled(false);
			showInfo(FClient.messages.getString("vote_send"));
			FClient.comms.sendVote(choice);
			jToggleButton1.setEnabled(false);
			jToggleButton2.setEnabled(false);
			jToggleButton3.setEnabled(false);
			jToggleButton4.setEnabled(false);
		} else if (FClient.vote_system.equals("borda-default")) { // Borda default code
			if (clicked) { // we've already clicked on this button so second time round they are sure
				/* error checking */
				if ((jTextField1.getText().equals("")) || (jTextField2.getText().equals("")) || (jTextField3.getText().equals("")) || (jTextField4.getText().equals(""))) {
					// an empty field - borda we're using doesn't allow empty field
					showError(FClient.messages.getString("fill_all"));
					jLabel2.setVisible(false); // reset interface
					jButton2.setEnabled(false);
					choice = "";
					clicked = false;
				} else if ((jTextField1.getText().equals("0")) || (jTextField2.getText().equals("0")) || (jTextField3.getText().equals("0")) || (jTextField4.getText().equals("0"))) {
					// invalid entry
					showError(FClient.messages.getString("invalid_chars"));
					jLabel2.setVisible(false); // reset interface
					jButton2.setEnabled(false);
					choice = "";
					clicked = false;
				} else if ((new Integer(jTextField1.getText()).intValue() + new Integer(jTextField2.getText()).intValue() + new Integer(jTextField3.getText()).intValue() + new Integer(jTextField4.getText()).intValue()) != bordaSum()) {
					// invalid entry
					showError(FClient.messages.getString("invalid_chars"));
					jLabel2.setVisible(false); // reset interface
					jButton2.setEnabled(false);
					choice = "";
					clicked = false;
				} else {
					choice = new String(cand1code + "-" + new Integer(FClient.number_of_choices - new Integer(jTextField1.getText()).intValue()).toString() + "-" + cand2code + "-" + new Integer(FClient.number_of_choices - new Integer(jTextField2.getText()).intValue()).toString() + "-" + cand3code + "-" + new Integer(FClient.number_of_choices - new Integer(jTextField3.getText()).intValue()).toString() + "-" + cand4code + "-" + new Integer(FClient.number_of_choices - new Integer(jTextField4.getText()).intValue()).toString());
					jLabel2.setVisible(false); // update interface & send vote
					jButton1.setEnabled(false);
					jButton2.setEnabled(false);
					showInfo(FClient.messages.getString("vote_send"));
					FClient.comms.sendVote(choice);
					jTextField1.setEnabled(false);
					jTextField2.setEnabled(false);
					jTextField3.setEnabled(false);
					jTextField4.setEnabled(false);
				}
			} else {
				jLabel2.setVisible(true);
				showInfo(FClient.messages.getString("sure"));
				jButton1.setEnabled(true);
				jButton2.setEnabled(true);
				clicked = true;
			}
		}
	}

	protected void jButton2ActionPerformed(java.awt.event.ActionEvent e) {
		jLabel2.setVisible(false);
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		choice = "";
		clicked = false;
	}

	protected void jButton3ActionPerformed(java.awt.event.ActionEvent e) {
		jButton3.setEnabled(false);
		jButton4.setEnabled(false);
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		FClient.comms.sendVote(choice);
		showInfo(FClient.messages.getString("vote_send2"));
	}
	
	protected void jButton4ActionPerformed(java.awt.event.ActionEvent e) {
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	protected void voteOK() {	
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		jButton4.setEnabled(true);
		jButton4.setEnabled(true);
		showInfo(FClient.messages.getString("vote_reg"));
	}
	
	protected void voteErr() {
		jButton1.setEnabled(false);
		jButton2.setEnabled(false);
		jButton3.setEnabled(true);
		jButton4.setEnabled(true);
		showError(FClient.messages.getString("vote_sorry"));
	}

	public static void main( String args[]) throws Exception{
		VoteFrame v = new VoteFrame();
		v.initComponents();
		v.setVisible(true);
	}


} //EOF Class

