/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package FreeClient;
 
/**
 * A simple thread which waits a certain time in milliseconds defined by
 * <code>FClient.timeOutTime</code> before closing communications.
 *
 * @version 0.5.5  12 April 2001
 * @author Jason Kitcat
 */
public class TimeOutThread extends Thread {

	public boolean threadStatus = true;

	public void stopThread() {
		threadStatus = false;
	}

	public void run() {
	
		while (threadStatus) {
		
			try {
				sleep(FClient.timeOutTime);
			} catch (InterruptedException e) {}

			if (threadStatus) {
				FClient.carryOn = false;
				if (FClient.ercheck) {  // make sure we're sending errors to the right screen
					FClient.frame4.showError(FClient.messages.getString("time_out"));
					FClient.frame4.status=false;
					FClient.frame4.jButton1.setVisible(true);
					FClient.frame4.jButton2.setVisible(true);
					FClient.frame4.jButton1.setEnabled(true);
					FClient.frame4.jButton2.setEnabled(true);
					FClient.frame4.showInfo(FClient.messages.getString("try_again"));
				} else {
					FClient.frame.showError(FClient.messages.getString("time_out"));
					FClient.frame.voteErr();
				}
			}
				
		} //eof while
	
	} //EOF run()

	
} //EOF TimeOutThread