/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package FreeClient;

import java.io.*;
import java.net.*;

import Free.util.*;

/**
 * TCPClient opens connections to servers and sends/receives all data.
 *
 * While TCPClient performs all the connection-level operations and deals
 * with errors, all data is passed to <code>ClientProtocol</code> for
 * for processing.
 *
 * @version 1.1 5 July 2001
 * @author Jason Kitcat
 */
public class TCPClient implements Runnable {

	/**
	 * run() delivers a packet to the server whose DNS address is chosen.
	 * 
	 */
	public void run() {
	
		String serverName="";
		String packetMsg;
		int port = 0;
		Socket freeSocket = null;
		PrintWriter out = null;
		BufferedReader in = null;
		
		/* get data */
		if (FClient.comms.getType()=='V') {
			serverName = FClient.comms.R_address;
			port = FClient.comms.freeRTPort;
		} else if (FClient.comms.getType()=='D') {
			serverName = FClient.comms.R_address;
			port = FClient.comms.freeRTPort;
		} else if (FClient.comms.getType()=='E') {
			serverName = FClient.comms.ER_address;
			port = FClient.comms.freePort;
		} else {
			FClient.frame.showInfo(FClient.messages.getString("unrec_type"));
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError(FClient.messages.getString("no_IO") + serverName);
				FClient.frame4.status=false;
				FClient.frame4.jButton1.setVisible(true);
				FClient.frame4.jButton2.setVisible(true);
				FClient.frame4.showInfo(FClient.messages.getString("try_again"));
			} else {
				FClient.frame.showError(FClient.messages.getString("no_IO") + serverName);
				FClient.frame.voteErr();
			}
		}
		
		packetMsg = FClient.comms.getMessage() + "\r\n";
		
		/* send packet */
		try {
			freeSocket = new Socket(serverName, port); // open connection
			out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(freeSocket.getOutputStream())), true);
			in = new BufferedReader(new InputStreamReader(freeSocket.getInputStream()));
			
			out.println(packetMsg); // write packet
			
		} catch (UnknownHostException e) {
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError(FClient.messages.getString("no_host") + serverName);
				FClient.frame4.status=false;
				FClient.frame4.jButton1.setEnabled(true);
				FClient.frame4.jButton2.setEnabled(true);
				FClient.frame4.showInfo(FClient.messages.getString("try_again"));
			} else {
				FClient.frame.showError("Unknown host: " + serverName);
				FClient.frame.voteErr();
			}
		} catch (IOException e) {
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError(FClient.messages.getString("no_IO") + serverName);
				FClient.frame4.status=false;
				FClient.frame4.jButton1.setEnabled(true);
				FClient.frame4.jButton2.setEnabled(true);
				FClient.frame4.showInfo(FClient.messages.getString("try_again"));
			} else {
				FClient.frame.showError(FClient.messages.getString("no_IO") + serverName);
				FClient.frame.voteErr();
			}
		} catch (Exception e) {
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError(FClient.messages.getString("err_connect") + e.getMessage());
				FClient.frame4.status=false;
				FClient.frame4.jButton1.setEnabled(true);
				FClient.frame4.jButton2.setEnabled(true);
				FClient.frame4.showInfo(FClient.messages.getString("try_again"));
			} else {
				FClient.frame.showError(FClient.messages.getString("err_connect") + e.getMessage());
				FClient.frame.voteErr();
			}
		}
		
		String inputData = "NONE";
		String[] outputData = new String[] {" ","NONE"};
		
		/* read response */
		try {
			
			while (FClient.carryOn) {
			
				if (in.ready()) {  // if there's data 
				
					inputData = in.readLine();
					
					if (!inputData.equals("")) { // check real data has arrived
						// decrypt data
						inputData = RSAEncrypt.blowDecrypt(FClient.comms.getsession_key(), inputData);

						// now process
						outputData = ClientProtocol.process(inputData);
						
						if ((outputData[1].equals("DONE"))|(outputData[1].equals("ERROR"))) {
						
							break;
							
						} else if (outputData[0].charAt(0)=='X') {
						
							out.println(outputData[1]);
							
							break;
							
						} else {
						
							out.println(outputData[1]);
							
						}
						
					}
					
				}
			
			}
						
			
		} catch (Exception e) {
			if (FClient.ercheck) {  // make sure we're sending errors to the right screen
				FClient.frame4.showError(FClient.messages.getString("connect_err") + e.getMessage());
			} else {	
				FClient.frame.showError(FClient.messages.getString("connect_err") + e.getMessage());
			}
		} finally {
			//tidy up
			try {
				out.close();
				in.close();
				freeSocket.close();
			} catch (Exception e) {
				if (FClient.ercheck) {  // make sure we're sending errors to the right screen
					FClient.frame4.showError(FClient.messages.getString("err_shut") + e.getMessage());
				} else {
					FClient.frame.showError(FClient.messages.getString("err_shut") + e.getMessage());
				}
			}
			FClient.comms.timer.stopThread();
			FClient.comms.timer = null;
			FClient.comms.setFromServer(outputData[1]);
		}
		
	} //EOF run
	
} //EOF TCPClient