/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package FreeClient;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

 /**
  * A screen to let voters enter their information for Electoral Roll authorisation.
 *
 * @version 0.8 28 October 2001
 * @author Jason Kitcat, Rajagopal C.V
  */
public class FCFrame3 extends Frame 
{

	Label jLabel1 = new Label();
	Label jLabel2 = new Label();
	Label jLabel3 = new Label();
	Label jLabel4 = new Label();
	TextField jTextField1 = new TextField();
	TextField jTextField2 = new TextField();
	TextField jPasswordField1 = new TextField();
	Button jButton1 = new Button();
	Label jLabel5 = new Label();

	protected FCFrame3() {
		
		setTitle(FClient.messages.getString("auth_title"));
		jLabel4.setText(FClient.messages.getString("auth_instruct"));
		jLabel1.setText(FClient.messages.getString("name"));
		jLabel2.setText(FClient.messages.getString("code"));
		jButton1.setLabel(FClient.messages.getString("ok_button"));
		jLabel3.setText(FClient.messages.getString("password"));
		jLabel5.setText(FClient.messages.getString("fill_all"));
		jPasswordField1.setEchoChar('*');
			
		FreePanel scrollPanel = new FreePanel(FClient.messages.getString("auth"));
		scrollPanel.setInsets(3, 3, 3, 3);
		
		scrollPanel.addComponent( 0, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel4);
		scrollPanel.addComponent( 1, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel1);
		scrollPanel.addComponent( 2, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jTextField1);
		scrollPanel.addComponent( 3, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel2);
		scrollPanel.addComponent( 4, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jTextField2);
		scrollPanel.addComponent( 5, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel3);
		scrollPanel.addComponent( 6, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jPasswordField1);
		scrollPanel.addComponent( 7, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel5);
		scrollPanel.addComponent( 7, 1, 1, 1, 0, 0, GridBagConstraints.NONE, 
			1.0f, 0.0f, jButton1);
		add(scrollPanel);
		setSize(new java.awt.Dimension(350, 300));
		setResizable( false);
	}

	protected void initComponents() throws Exception
	{

		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
	}
	
 	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
	
	}
	
	protected void jButton1ActionPerformed(java.awt.event.ActionEvent e) {

		if (jTextField1.getText().equals("")|jTextField2.getText().equals("")|jPasswordField1.getText().equals("")) {
			jLabel5.setVisible(true);
		} else if (!FClient.isSafe(jTextField1.getText())|!FClient.isSafe(jTextField2.getText())|!FClient.isSafe(jPasswordField1.getText())) {
			jLabel5.setText(FClient.messages.getString("invalid_chars"));
			jLabel5.setVisible(true);
		} else {
			jLabel5.setText("");
			jLabel5.setVisible(false);
			setVisible(false);
			FClient.frame4.setVisible(true);
			FClient.frame4.showInfo(FClient.messages.getString("auth_details"));
			FClient.comms.sendAuth(jTextField1.getText(), jTextField2.getText(), jPasswordField1.getText());
		}
	
	}
	
	protected void cleanUp() {
		dispose();
	}
	
	
}
