/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package FreeClient;

import java.io.*;
import java.net.*;
import java.util.*;
import Free.util.*;

/**
 * Comms is the key class for launching communications with servers.
 *
 * The class launches a thread for TCP/IP communications and also contains
 * the methods for building packets. These packets are then held in
 * <code>message</code> for retrieval by <code>TCPClient</code>
 *
 * @version 1.1 8 September 2001
 * @author Jason Kitcat
 */
public class Comms {

	private Thread talker;
	private Runnable tk;
	protected TimeOutThread timer;
	
	/** constant to hold address of regional server */
//#ifdef INSTALL
	protected static final String R_address = "huxley.swingdigital.com";
	/** constant to hold address of electoral roll server */
//#ifdef INSTALL
	protected static final String ER_address = "212.42.168.209";
	/** constant to store value being used as GNU.FREE port number
	 * For security reasons I recommend this is changed regularly
	 */
//#ifdef INSTALL
	protected static final int freePort = 1111;
//#ifdef INSTALL
	protected static final int freeRTPort = 1122; //XXXX
	/** public and private keys for communications */
//#ifdef INSTALL
	protected static final String rt_public_key = "001101000108008193745AA3A2733EF1140758495439CB4CD188C4F2B5D2FA84C3C533465991257EAFC2BCAC0AC07F1531C97489723A353E7A1C911E687A5E834CD872B534480D8B4F9107E48C994A0D5B68870DE4DC3A51C604572446F166E02B8F234C44158FD373A06CFF30E3BBA2F1E670743D7B855CC2D3EF395D440A702D57013A5146171E4B7C78343FB2DAA47E56C63A2B5CFA57FF8892399F0A7D8E47A0203C687A158D3E0802AE02D3C1EA4AC625B641430FA9A1A50FC095461EED1DF401F93365CD650D02CFD4392BE1349B29900A0DCA648658FAFA3E8C3300E44C705AF3930F5EDF28B5D40C89251F440C9038DD9F533A849965EB71617D91A5CFD5621ED6A5D1";
//#ifdef INSTALL
	protected static final String er_public_key = "001101000108009539E6A8D4A7F01D33BBF0E9E273373874AC8A3D226FC75E7F8C464B673E0DF6BEA371B169EC1EDA382A4D5BBD1973963C0B57BE8B0EE16ADF3194D2EAE630B15E2E1BEF2AC34AA8061341D3F6D6010F72210A671F8653A3FC0B03F6F31FB0E480444AE98658D95404EE62C2A5C063F830A4DB52EEB2E02EE6E9310C2A95875CE1D8A1DE8BA03271198A15076F1D65574C1A8C1FF39FAEE8A43EDE11DE22E41ED8E3B1DBC57E58C978259B7A846998E5CFCEDF1EB75F12A6481FD86AA29E2F9184F0BF522F0553EF806927D167187F4F3A7233EB6F3080A7E131C0911EF82C08A86FE4C0F0B6F53E580F81568C59BFE4C131B78F1E66B879858D6C05060058B1";
//#ifdef INSTALL
	protected static final String fc_private_key = "";
	 
	
	/** For returning data from <code>TCPClient</code>. Not currently used. */
	private String fromServer;
	/** The HMAC key from the server's seed */
	private String server_hmac_key;
	/** The server's seed to build the HMAC key */
	private String server_hmac_seed;
	/** The HMAC key from the client's seed */
	private String client_hmac_key;
	/** The client's seed to build the HMAC key */
	private String client_hmac_seed;
	/** The packet sequence number */
	private int sequence_number;
	/** Holds the check time/date stamp for GNU.FREE security protocol */
	private Date check;
	/** Holds the session key for GNU.FREE security protocol */
	private String session_key;
	/** A string holding the packet to be initially sent to a server */
	private String message;
	/** A string holding the packet to be sent after the first in cases where message is an I packet */
	private String message_two;
	/** Stores the AuthKey from ERServer until sent to RTServer when cleared */
	private String ERAuthKey;
	/** Stores the type of packet being sent, using the same flags as for
	 * section 1 of a GNU.FREE packet. This is used to determine which server
	 * to send <code>message</code> to.
	 */
	private char type;
	
	/* constructor */
	protected Comms() {
	
		// unneccessary but just in case!
		message = "";
		message_two = "";
		fromServer = "";
		sequence_number = 0;
		ERAuthKey="";
	
	}

	/* simple acessor method */
	protected void setFromServer(String x) {
	
		fromServer = x;
	
	}
	
	/* simple acessor method */
	protected Date getCheck() {
	
		return check;
	
	}
	
	/* simple acessor method */
	protected String getsession_key() {
	
		return session_key;
	
	}
	
	/* simple acessor method */
	protected void setsession_key(String x) {
	
		session_key = x;
	
	}
	
	/* simple acessor method */
	protected String getERAuthKey() {
	
		return ERAuthKey;
	
	}
	
	/* simple acessor method */
	protected void setERAuthKey(String x) {
	
		ERAuthKey = x;
	
	}

	/* simple acessor method */
	protected void noCheck() {
	
		check = null;
	
	}
	
	/* simple acessor method */
	protected String getMessage() {
	
		return message;
	
	}

	/* simple acessor method */
	protected String getMessage_two() {
	
		return message_two;
	
	}

	/* simple acessor method */
	protected char getType() {
	
		return type;
	
	}

	/* simple acessor method */
	protected String getServer_hmac_key() {
	
		return server_hmac_key;
	
	}
	
	/* simple acessor method */
	protected void setServer_hmac_key(String x) {
	
		server_hmac_key = x;
	
	}
	
	/* simple acessor method */
	protected String getClient_hmac_key() {
	
		return client_hmac_key;
	
	}
	
	/* simple acessor method */
	protected void setClient_hmac_key(String x) {
	
		client_hmac_key = x;
	
	}
	
	/* simple acessor method */
	protected String getClient_hmac_seed() {
	
		return client_hmac_seed;
	
	}
	
	/* simple acessor method */
	protected String getServer_hmac_seed() {
	
		return server_hmac_seed;
	
	}
	
	/* simple acessor method */
	protected void setServer_hmac_seed(String x) {
	
		server_hmac_seed = x;
	
	}
	
	/* simple acessor method */
	protected int getSequence_number() {
	
		return sequence_number;
	
	}
	
	/* simple acessor method */
	protected void setSequence_number(int x) {
	
		sequence_number = x;
	
	}

	/**
	 * sendVote creates check date for security and sends a vote packet.
	 *
	 * @param party  String to hold voter's choice
	 */
	 protected void sendVote(String party) {	 
		
		tk = new TCPClient();
		talker = new Thread(tk);

		String reply;
		
		FClient.carryOn = true;
		
		check = new Date();

		try {
			setsession_key(RSAEncrypt.makeSessionKey());
			setSequence_number(0);
		
			client_hmac_seed = RSAEncrypt.makeSessionKey();  // Initialise protocol values
			client_hmac_key = AuthSys.seedToKey(client_hmac_seed);
			
			message = RSAEncrypt.pubEncrypt(rt_public_key,getsession_key()) + "-" + RSAEncrypt.blowEncrypt(getsession_key(),"I|" + client_hmac_seed + "|" + AuthSys.makeDigest("I|" + client_hmac_seed));  // send protocol init
			
			message_two = new Packet('V',check.toString() + "-" + ERAuthKey + "-" + party,getsession_key(),rt_public_key,getClient_hmac_key(),2).toCryptString(true); //real data

			type = 'V'; // bogus type as we're really sending an I packet but
						// this the second packet type we'll be sending.
			
			timer = new TimeOutThread();
			timer.start(); // start timeout system
		
	 		talker.start();  // start communications

			reply = fromServer;
			
	 	} catch (Exception e) {
	 		FClient.frame.showError(FClient.messages.getString("sendV_IO_err") + e.getMessage());
	 	}
	 			
	 }  //EOF sendVote


	/* IMPORTANT NOTE: sendAuth is only a demo implementation and is not necessarily secure.
	   This method will need reimplementation depending on how you want to authorise voters.
	   In later versions of GNU.FREE I hope to make this more flexible. e.g. support smart cards.
	 */

	/**
	 * sendAuth dispatches a packet to the ERServer for voter authentication.
	 * Since 1.5 the PIN and password have been sent as digests.
	 *
	 * @param name  Name of user
	 * @param code  A unique code for this election only
	 * @param password  Self explanatory
	 */
	protected void sendAuth(String name, String code, String password) {
	
		tk = new TCPClient();
		talker = new Thread(tk);

		String reply, data;
		
		FClient.carryOn = true;
		
		type = 'E'; // bogus type as we're really sending an I packet but
					// this the second packet type we'll be sending.
			
		try {
			setsession_key(RSAEncrypt.makeSessionKey());
			setSequence_number(0);
		
			client_hmac_seed = RSAEncrypt.makeSessionKey();  // initialise protocol values
			client_hmac_key = AuthSys.seedToKey(client_hmac_seed);
			
			message = RSAEncrypt.pubEncrypt(er_public_key,getsession_key()) + "-" + RSAEncrypt.blowEncrypt(getsession_key(),"I|" + client_hmac_seed + "|" + AuthSys.makeDigest("I|" + client_hmac_seed));  // send protocol init
			
			message_two = new Packet('E',name + "-" + AuthSys.makeDigest(code) + "-" + AuthSys.makeDigest(password),getsession_key(),er_public_key,getClient_hmac_key(),2).toCryptString(true); //real data
		
			type = 'E'; // bogus type as we're really sending an I packet but
						// this the second packet type we'll be sending.
						
			timer = new TimeOutThread();
			timer.start(); // start timeout system
		
	 		talker.start();  // start communications
		 	
		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		FClient.frame4.showError(FClient.messages.getString("sendA_IO_err") + e.getMessage());
	 		FClient.frame4.status=false;
	 		FClient.frame4.jButton1.setVisible(true);
	 		FClient.frame4.jButton2.setVisible(true);
	 		FClient.frame4.showError(FClient.messages.getString("try_again"));
	 	}
	
	} //EOF sendAuth
	 

	/**
	 * sendDiag dispatches any diagnostic packets for debugging.
	 *
	 * @param msg  Data for packet
	 */
	 protected void sendDiag(String msg) {	 
		
		tk = new TCPClient();
		talker = new Thread(tk);

		String reply;
		
		FClient.carryOn = true;
		
		type = 'D'; // bogus type as we're really sending an I packet but
					// this the second packet type we'll be sending.
	
		try {
			setsession_key(RSAEncrypt.makeSessionKey());
			setSequence_number(0);
		
			client_hmac_seed = RSAEncrypt.makeSessionKey();  // initialise protocol values
			client_hmac_key = AuthSys.seedToKey(client_hmac_seed);
			
			message = RSAEncrypt.pubEncrypt(er_public_key,getsession_key()) + "-" + RSAEncrypt.blowEncrypt(getsession_key(),"I|" + client_hmac_seed + "|" + AuthSys.makeDigest("I|" + client_hmac_seed));  // send protocol init
			
			message_two = new Packet('D',msg,getsession_key(),er_public_key,getClient_hmac_key(),2).toCryptString(true); //real data
			
			timer = new TimeOutThread();
			timer.start(); // start timeout system
		
	 		talker.start();  // start communications
		 	
		 	reply = fromServer;
		 	
	 	} catch (Exception e) {
	 		FClient.frame.showError(FClient.messages.getString("sendD_IO_err") + e.getMessage());
	 	}
	 			
	 }  //EOF sendDiag

	
} //EOF Class