/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
 // statement below kept out of good form but this code was taken from the GPLed NFC Chat system.
 
/*
 * Copyright (c) 2000 Lyrisoft Solutions, Inc.
 * Used by permission
 */
package Free.awt;

import java.awt.*;

/**
 * A Scrollable View that a TextView can be placed in.<br>
 * <br>
 * Originally from NFC Chat. Modified for use in GNU.FREE<br>
 * <br>
 * Works in JDK1.0.2<br>
 * <br>
 *
 * @version 1.0 2 April 2001
 * @author Jason Kitcat
 * @since 1.6
 */
public class ScrollView extends Panel {
    TextView _view;
    Scrollbar _scrollbar;
    static boolean WORKAROUND_ENABLED;

    /**
     * Work-around for the scrolling inconsitency.
     * Details on http://developer.java.sun.com/developer/bugParade/bugs/4070498.html
     */
    static {
        WORKAROUND_ENABLED = ((new Scrollbar(Scrollbar.HORIZONTAL,20,10,0,20)).getValue() == 20);
//        System.err.println("Scrollbar WORKAROUND_ENABLED = " + WORKAROUND_ENABLED);
    }

    /**
     * Construct a ScrollView that will scroll a TextView
     */
    public ScrollView(TextView view) {
        _view = view;
        _scrollbar = new Scrollbar(Scrollbar.VERTICAL);
        _scrollbar.setLineIncrement(10);
        _scrollbar.setBackground(Color.lightGray);
        setLayout(new BorderLayout());
        add("Center", view);
        add("East", _scrollbar);

        view.setScrollView(this);
    }

    /**
     * This method does what its name implies.
     */
    public void scrollToBottom() {
        int max = _scrollbar.getMaximum();
        _scrollbar.setValue(max);
        scroll();
    }

    /**
     * Notification that the bounds of my view object changed.
     * Adjust the ScrollBar appropriately.
     */
    public void boundsChanged() {
        int viewableHeight = _view.size().height;
        int fullHeight = _view.preferredSize().height;

        if (WORKAROUND_ENABLED) {
            fullHeight -= viewableHeight;
        }
        _scrollbar.setValues(_scrollbar.getValue(), viewableHeight, 0, fullHeight);
        scroll();
    }

    /**
     * Make the TextView consistent with the position of the ScrollBar
     */
    void scroll() {
        _view.setYTranslation(_scrollbar.getValue());
        _view.repaint();
    }

    /**
     * Catch events from the ScrollBar.  Upon doing so, call scroll()
     */
    public boolean handleEvent(Event event) {
        if (event.target == _scrollbar) {
            scroll();
            return true;
        } else {
            return super.handleEvent(event);
        }
    }
}
