/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


package Free.awt;

import java.awt.*;
import java.util.Vector;
import java.util.StringTokenizer;


/**
 * FreePanel
 *
 * @version 0.1 30 January 2001
 * @author Rajagopal C.V
 * @since 1.5
 */

public class FreePanel extends Panel {



	public final static int		TEXT_OFFSET = 5;

	protected int				style;

	protected int				thickness = 2;

	protected int				myWidth;

	protected int				myHeight;

	protected String			text = "";

	GridBagLayout gbl = new GridBagLayout();



	public final static int RAISED = 1;

	

	// For setting the default insets;

	//

	int top = 2;

	int left = 2;

	int bottom = 2;

	int right = 2;



	// Colors

	//

	Color backgroundColor;

	Color lighterColor;

	Color darkerColor;



	public FreePanel() {

	

		super();

	}



	public FreePanel( int style ) {

		this.style = style;

	}



	/**
	 * Creates a FreePanel
	 *
	 * @param text  The text to display in the panel.
	 */
	public FreePanel( String text ) {

		style = RAISED;

		this.text = text;	

	}

	
	/**
	 * adds a widget to the FreePanel
	 *
	 * @param row  The row to insert at.
	 * @param col  The column to insert at.
	 * @param high  The height of the component.
	 * @param wide  The width of the component.
	 * @param padx  Padding on the X-axis.
	 * @param pady  Padding on the Y-axis.
	 * @param fill  The fill (integer).
	 * @param weightx  X-axis weighting.
	 * @param weighty  Y-axis weighting.
	 * @param theComponent  The actual component to add.
	public void addComponent(int row, int col, int high, int wide, 

		int padx, int pady, int fill, float weightx, float weighty, 

		Component theComponent){

		

		GridBagConstraints gbc = new GridBagConstraints();

		gbc.gridx = col;

		gbc.gridy = row;

		gbc.ipady = pady;

		gbc.ipadx = padx;

		gbc.gridwidth = wide;

		gbc.gridheight = high;

		gbc.fill = fill;

		gbc.anchor = anchor;

		gbc.weightx = weightx;

		gbc.weighty = weighty; 

		gbc.insets = new Insets(top, left, bottom, right);

		gbl.setConstraints( theComponent, gbc);

		setLayout(gbl);

		add( theComponent);

	}

	

	public void setInsets( int Top, int Left, int Bottom, int Right ){

	

		top = Top;

		left = Left;

		bottom=Bottom;

		right = Right;

	}

	

	int anchor = GridBagConstraints.CENTER;

	public void setAnchor( int Anchor ) {

	

		anchor = Anchor;

	}



	public void setGridWidths( int colWidths[] ) {

	

		gbl.columnWidths = colWidths;

	}

	

	public void setGridHeights( int rowHeights[] ) {

	

		gbl.rowHeights = rowHeights;

	}





	public void addNotify() {

	

		super.addNotify();



		// get parent bacground colors

		//

		backgroundColor = getParent().getBackground();

		lighterColor = backgroundColor.brighter( );

		darkerColor = backgroundColor.darker();

		getMetrics();

	}



	public Insets getInsets() {

	

		int		space = thickness + 1;

		int 	topSpace = space;

		int		leftSpace = space;

		int		rightSpace = space;



		//if ( isStyleSet( CAPTION ) )

		if ( text != "")

		{

			FontMetrics fm = getFontMetrics( getFont() );



			if ( fm != null )

				topSpace += ( fm.getHeight() / 2 ) + 1;

		}



		return( new Insets( topSpace, space, space, space ) );

	}

	

	// getMetrics

	// Figures out the size I should be based on what I contain

	//	

	public void getMetrics() {

	

		Dimension d = getMinimumSize();

		setSize( d.width, d.height );

		

	}

/*

	// minimumSize                                                      *

	//

	public Dimension getMinimumSize() {

	

		int		tempWidth, tempHeight;



		if ( myWidth != 0 && myHeight != 0 )

		{

			tempWidth = myWidth + ( thickness * 2 );

			tempHeight = myHeight + ( thickness * 2 );



			return( new Dimension( tempWidth, tempHeight ) );

		}



		Dimension d = super.getMinimumSize();



		FontMetrics	fm = getFontMetrics( getFont() );



		if ( fm != null && text != null )

		{

			int extra = ( thickness * 2 ) + ( TEXT_OFFSET * 2 );



			d.height += fm.getHeight() + extra;

			d.width += fm.stringWidth( text ) + extra;

		}



		d.width += thickness * 2;

		d.height += thickness * 2;

		return( d );

	}

	

	// preferredSize

	//

	public Dimension getPreferredSize() {

	

		return( getMinimumSize() );

	}

*/

	public void setFont( Font f ) {

	

		super.setFont( f );

		repaint();

	}



	public void paint( Graphics g ) {

		super.paint( g );



		if ( getSize().width < 1 )

			getMetrics();



		if ( style == RAISED )

		{

			drawRaisedFrame( g );



			if ( text != "" && text != null )

				printCaption( g );

		}

	}



	public void drawRaisedFrame( Graphics g ) {

	

		int	i, j, offset = 0;

		Dimension	bounds = getSize();



		if ( text != "")

		{

			FontMetrics fm = g.getFontMetrics();

			offset = fm.getHeight() / 2;

		}



		for ( i = 0, j = 1; i < thickness; i++, j += 2 ){

			g.setColor( lighterColor );

			g.fillRect( i, i+offset, bounds.width - ( 2 * ( i) ), 1 );

			g.fillRect( i, i+offset, 1, bounds.height - ( 2 * i + 1 ));

			g.setColor( darkerColor);

			g.fillRect( i, bounds.height - ( i + 1 ), bounds.width - ( 2 * (i) ), 1 );

			g.fillRect( bounds.width - ( i + 1 ), i + offset ,1, bounds.height - ( 2 * i+1 ) );

		}

	}

	

	public void printCaption( Graphics g ) {

	

		Color				oldColor = g.getColor();

		int					xx = 0, yy = 0;

		FontMetrics			fm = g.getFontMetrics();

		Dimension			bounds = getSize();

		Font t_oldFont = g.getFont();

		g.setFont( new Font( t_oldFont.getName(), Font.BOLD, t_oldFont.getSize()));

		int spacer = fm.charWidth( 'i' );

		xx = thickness + TEXT_OFFSET + spacer;

		yy = 0;

		g.setColor( getBackground() );

		g.fillRect( xx, yy,

			fm.stringWidth( text ) + ( spacer * 2 ),

			fm.getHeight() );

		xx += spacer;

		yy += fm.getHeight() - fm.getDescent() - 1;

		g.setColor( Color.black );

		g.drawString( text, xx, yy );

		//	Restore the old color...

		//

		g.setColor( oldColor );

		g.setFont( t_oldFont);

	}

	

	/**

	 * A simple little method, adatped from O'Reilly's 'Java Swing', to

	 * show a title screen in the centre of the screen for a certain time.

	 *

	 * @param duration  The time to show the screen for

	 */

	

	public static void showSplash(int duration) {

		Window content = new Window(new Frame());

		

		//set the window's bounds, centering the window

		int width = 400;

		int height = 200;

		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();

		int x = (screen.width-width)/2;

		int y = (screen.height-height)/2;

		content.setBounds(x,y,width,height);

		

		//build the splash screen

		RxImageLabel label = new RxImageLabel("splash");

		content.add(label, BorderLayout.CENTER);

		

		content.setVisible(true);

		

		//Wait a while

		try { Thread.sleep(duration); } catch (Exception e) {}

		

		content.setVisible(false);

		

	} //EOF showSplash





}



