/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package Free;

import java.io.*;
import java.net.*;

import Free.util.*;

/**
 * TCPClient allows <code>RTServer</code> to connect as a client to
 * a totaller server when the ballot has closed.
 *
 * While TCPClient performs all the connection-level operations and deals
 * with errors, all data is passed to <code>ClientProtocol</code> for
 * for processing.
 *
 * @version 1.2 30 August 2001
 * @author Jason Kitcat
 */
public class TCPClient implements Runnable {

	String message="";
	int vectIndex=0;
	
	/**
	 * constructor
	 */
	 public TCPClient(String m, int v) {
	 	message=m;
	 	vectIndex=v;
	 }
	 
	/**
	 * run() delivers a packet to the server whose DNS address is chosen
	 * 
	 */
	public void run() {
	
		String serverName="";
		String packetMsg;
		int port=0;
		Socket freeSocket = null;
		PrintWriter out = null;
		BufferedReader in = null;
		
		/* get data */
		if (RTServer.comms.getType()=='T') {
			serverName = RTServer.comms.T_address;
			port = RTServer.comms.freeRTPort;
		} else if (RTServer.comms.getType()=='D') {
			serverName = RTServer.comms.ER_address;
			port = RTServer.comms.freePort;
		} else if (RTServer.comms.getType()=='K') {
			serverName = RTServer.comms.ER_address;
			port = RTServer.comms.freePort;
		} else if (RTServer.comms.getType()=='Q') {
			serverName = RTServer.comms.ER_address;
			port = RTServer.comms.freePort;
		} else {
			// let's get defensive
			RTServer.NORM.warn("Unknown packet type");
			RTServer.carryOn = false;
		}
		
		packetMsg = message + "\r\n";
		
		/* send packet */
		try {
			freeSocket = new Socket(serverName, port);  // establish connection
			out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(freeSocket.getOutputStream())), true);
			in = new BufferedReader(new InputStreamReader(freeSocket.getInputStream()));			
	
			out.println(packetMsg); // write packet
			
		} catch (UnknownHostException e) {
			RTServer.NORM.error("Unknown host: " + serverName);
			RTServer.NORM.error("Terminal Total Error: Quitting Total process!");
			RTServer.frame.jButton1.setEnabled(true);
			RTServer.carryOn = false;
		} catch (IOException e) {
			RTServer.NORM.error("Couldn't get I/O for the connection to: " + serverName);
			RTServer.NORM.error("Terminal Total Error: Quitting Total process!");
			RTServer.frame.jButton1.setEnabled(true);
			RTServer.carryOn = false;
		} catch (Exception e) {
			RTServer.NORM.error("Connection error: " + e.getMessage());
			RTServer.NORM.error("Terminal Total Error: Quitting Total process!");
			RTServer.frame.jButton1.setEnabled(true);
			RTServer.carryOn = false;
		}
		
		String inputData = "NONE";
		String[] outputData = new String[] {" ","NONE"};
		
		/* read response */
		try {
			
			while (RTServer.carryOn) {
			
				if (in.ready()) {  // if there's data 
				
					inputData = in.readLine();
					
					if (!inputData.equals("")) { // check real data has arrived
		
						// decrypt data
						String[] sess_data = RTServer.comms.getSession(vectIndex);
						inputData = RSAEncrypt.blowDecrypt(sess_data[5], inputData);
						RTServer.comms.setSession(vectIndex,sess_data[5],sess_data[0],sess_data[1],sess_data[2],sess_data[3],new Integer(sess_data[4]).intValue(),sess_data[6]); // we need to setSession() as getSession() empties data
						
						if(RTServer.DEV.isDebugEnabled()) {
							RTServer.DEV.debug("Received: " + inputData);
						}
						// now process
						outputData = ClientProtocol.process(inputData, vectIndex);
						
						if ((outputData[1].equals("DONE"))|(outputData[1].equals("ERROR"))) {
						
							break;
							
						} else if (outputData[0].charAt(0)=='X') {
						
							out.println(outputData[1]);
							
							break;
							
						} else {
						
							out.println(outputData[1]);
							
						}
						
					}
					
				}
			
			}
									
		} catch (Exception e) {
			RTServer.NORM.error("Error: " + e.getMessage());
		} finally {
			//tidy up
			try {
				out.close();
				in.close();
				freeSocket.close();
				RTServer.NORM.info("Closing connection.");
			} catch (Exception e) {
				RTServer.NORM.error("Error shutting connection: " + e.getMessage());
			}
			
			((TimeOutThread) RTServer.comms.threadTimeOut.elementAt(vectIndex)).stopThread(); //stop timeout
			RTServer.comms.setFromServer(outputData[1]);
			RTServer.comms.threadTimeOut.setElementAt("",vectIndex);  //clear out threads
			RTServer.comms.threadVect.setElementAt("",vectIndex);
		}

	} //EOF run
	
} //EOF TCPClient