/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package Free;

import java.net.*;
import java.io.*;
import java.awt.*;

import Free.awt.*;
import Free.util.*;

import org.apache.log4j.*;

/**
 * This is the main class which launches the <code>RTServer</code> program,
 * splash screen and preloads some objects.
 *
 * Worthy of note is the <code>startDaemon</code> which fires up the database,
 * logging system and TCP/IP server initialisation code.
 *
 * @version 1.4 27 October 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class RTServer {

	/** public and private keys for communications */
//#ifdef INSTALL
	protected static final String er_public_key = "001101000108009539E6A8D4A7F01D33BBF0E9E273373874AC8A3D226FC75E7F8C464B673E0DF6BEA371B169EC1EDA382A4D5BBD1973963C0B57BE8B0EE16ADF3194D2EAE630B15E2E1BEF2AC34AA8061341D3F6D6010F72210A671F8653A3FC0B03F6F31FB0E480444AE98658D95404EE62C2A5C063F830A4DB52EEB2E02EE6E9310C2A95875CE1D8A1DE8BA03271198A15076F1D65574C1A8C1FF39FAEE8A43EDE11DE22E41ED8E3B1DBC57E58C978259B7A846998E5CFCEDF1EB75F12A6481FD86AA29E2F9184F0BF522F0553EF806927D167187F4F3A7233EB6F3080A7E131C0911EF82C08A86FE4C0F0B6F53E580F81568C59BFE4C131B78F1E66B879858D6C05060058B1";
//#ifdef INSTALL
	protected static final String fc_public_key = "";
//#ifdef INSTALL
	protected static final String rt_private_key = "07FF67A7D8FDA547905FFAA52617075A3C7D98EF4A351B603EEDAF8598DCA2DB85D473DB10B2B40249E99FBFDB43C1AC424A53B785E0C56D98EEC0A499C67194E84B0575DA34712DD476BBE6B2E0CF4994AF86B91CC1C540875EDFD798C30900B22B0361CD2544A40C9A0F08EA6A6D62BDCC7ADF54815BE77345D26542E3B58E4CBD8C164861C04449A4B69109E34EFD24EAD872AD27339A201E20FE575D2167BA93D9BBDAB129D3D86805EB9554EC6EC5E2840693414052699ADC02C16D5E590678E6869F468BC0FDE8212CFB03DF5CCEFA8D18F1AC3CE44E12A5399690A620BD295A2DE3275262A9D26B60C0293725691B749059060D84352B96A9362E9CF9D90D0400D7FEAA4676144B2F8D6C0DF232F80D77C766857A627A31C2A297F7F24CDFCF58DFFEAE18B60E6433700336B88E474D1C35CF15E7EAC46C098C58DFCCF4EF11B543E46DBCB0CE44172833EA2871436883317D64BA529B0D837881DC43EB50BF71D13894C8820F8E961BDFE805791976FB6E9F74A611CB905D23E64A51B7BB3BDF0400999343FA335EE2FBAC4467F35E214237F5FC4036C7B8CD6180C2E126D8C2A484A5DDA7C5E17CFA36DC59EA05D19CD4BC4CB31A0745CF01A8A2CB63F71000F07A18C59AF3FADB6073B50A979A0E431043AA2077A46CDE99DF0186DA41DA44EC5650AFEA908CF860E414F9469353BB6E26892BF379E45F449DC7CC684110D6544F0400B0259B5F5D25A17AAD7497AE901DF95AABA1399C86623427971966E06362FF445A9630E654D83FF5E32FA05C1D154C49DB4E8866984276F307535A091D60F5795539CF215D2B6DF0FBDADF88785804A6B125D528A365F3AFB8C030EE33FCBAC2C29D79A84EDD9356644E7311C66C67CCB0B240A193AA968FA2890924676DC516";
//#ifdef INSTALL
	protected static final String rt_public_key = "001101000108008193745AA3A2733EF1140758495439CB4CD188C4F2B5D2FA84C3C533465991257EAFC2BCAC0AC07F1531C97489723A353E7A1C911E687A5E834CD872B534480D8B4F9107E48C994A0D5B68870DE4DC3A51C604572446F166E02B8F234C44158FD373A06CFF30E3BBA2F1E670743D7B855CC2D3EF395D440A702D57013A5146171E4B7C78343FB2DAA47E56C63A2B5CFA57FF8892399F0A7D8E47A0203C687A158D3E0802AE02D3C1EA4AC625B641430FA9A1A50FC095461EED1DF401F93365CD650D02CFD4392BE1349B29900A0DCA648658FAFA3E8C3300E44C705AF3930F5EDF28B5D40C89251F440C9038DD9F533A849965EB71617D91A5CFD5621ED6A5D1";
	
	/** defines the voting system */
//#ifdef INSTALL
	protected static final String vote_system = "borda-default";
//#ifdef INSTALL
	protected static final String count_system = "default";
//#ifdef INSTALL
	protected static final int number_of_choices = 4;
//#ifdef INSTALL
	protected static final String write_in = "no";
	
	
	
	// Time, in milliseconds, before a connection times out
	protected static final long timeOutTime = 300000;

	// variable for stopping comms after time out
	protected static boolean carryOn = true;
	
	// Tells us whether we're a regional or totaller server
	protected static char serverType;
	
	// Stores how many regional servers there are
	protected static int rServers;

	// Stores how many regional servers have sent totals
	protected static int rServersDone;

	// AWT frames
	protected static RTFrame frame;
	protected static Intro frame2;
	protected static DBFrame frame3;
	protected static TCPServer serv;
	protected static CryptFrame frame1;
	
	// Key for communicating to totaller server
	protected static Comms comms;
	
	// logging categories
	protected static Category NORM;
	protected static Category DEV;

	protected RTServer() 
	{
		try {
			// For native Look and Feel, uncomment the following code.
			/*
			try {
				UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			} 
			catch (Exception e) { 
			}
			*/
			
			rServers = 0;
			rServersDone = 0;
						
			FreePanel.showSplash(4000);
			
			// initiate GUI
			frame2 = new Intro();
			frame2.initComponents();
			frame2.setVisible(true);
			frame1 = new CryptFrame();
			frame1.initComponents();
			frame = new RTFrame();
			frame.initComponents();
			frame3 = new DBFrame();
			frame3.initComponents();
			
			// initiate communications
			comms = new Comms();
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	// Main entry point
	static protected void main(String[] args) 
	{
		new RTServer();
	}
	

	/**
	 * Fires up the database, logging system and TCP/IP server.
	 *
	 * It also checks to see what mode the software is running in and adapts
	 * the GUI accordingly. Logging is done with <code>log4j</code>, more info
	 * is available from
	 * <a href="http://www.log4j.org/">http://www.log4j.org/</a>.
	 *
	 */
	protected static void startDaemon() {
	
		try {
		
			// init logging system
			ScreenAppender A1 = new ScreenAppender();
			
			// log exists? If so get starting data
			String tempInData = "";
			String secInitString = "STARTING VALUE";
			try {
				BufferedReader t_in = new BufferedReader(new FileReader("erserver.log"));
				String inData = t_in.readLine();
				while (inData!=null) { // get to the last line
					tempInData = inData;
					inData = t_in.readLine();
				}
			 	t_in.close();
			 	inData = tempInData;
			 	
				if (inData!="" || inData!=" ") {  // only change starting value if something there
					// parse that last line
					int i=0;
					int t=0;

					while (inData.charAt(i)!=']') {
						i++;
					}
				
					t = i+5; // skip a safe amount (we know cat data there)
			
					while (inData.charAt(t)!='-') {
						t++;
					}
				
					secInitString = inData.substring(t+2); // got true logging data
				}
			 	
			 } catch (FileNotFoundException fnfe) {
			 	// file not there
			 }
			 
			SecureAppender A2 = new SecureAppender(secInitString);
			PropertyConfigurator.configure("log4j.rtserver.properties");			
			NORM = Category.getInstance("NORM");
			NORM.addAppender(A1);
			NORM.addAppender(A2);
			/* comment out the DEV portion to reduce log detail */
			DEV = Category.getInstance("DEV");
			DEV.addAppender(A1);
			DEV.addAppender(A2);

			NORM.info("GNU.FREE RTServer 0.13 starting up...");

			// start up our database
			DBase.init();

			// intialise AuthSys
			AuthKey.init();
			RSAEncrypt.init();
			
			// launch TCPServer services
			serv = new TCPServer();
			serv.startServer(comms.freeRTPort);

			if (RTServer.serverType == 'R') {
				RTServer.frame.jButton1.setVisible(true);
				NORM.info("Regional server mode");
			} else {
				RTServer.frame.jButton1.setVisible(false);
				NORM.info("Totaller server mode");
			}
			
			NORM.info("Server daemon started");

		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
	
	} //EOF startDaemon

	
} //EOF Class
