/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package Free;

import java.awt.*;
import java.awt.event.*;
import java.sql.*;

import Free.awt.*;

/**
 * Simple database console for executing SQL queries.
 *
 * @version 0.5 2 April 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class DBFrame extends Frame implements ActionListener
{

	// member declarations
	Label jLabel1 = new Label();
	ScrollPane jScrollPane1 = new ScrollPane();
    TextView tv;
	ScrollView sv;
	Font f;
	Font f2;
	TextStyle normal;
	TextStyle red;
	TextStyle blue;
	TextStyle green;
	Label jLabel2 = new Label();
	TextField jTextField1 = new TextField();
	Button jButton1 = new Button();

	// menu vars
	MenuBar mb;
	Menu m1;
	MenuItem item1, item2;

	public Insets getInsets(){ return new Insets(30, 10, 10, 10);}

	public DBFrame() {

		// prepare textView
		tv = new TextView(true);
        sv = new ScrollView(tv);
        f = new Font("Courier", Font.PLAIN, 12);
        f2 = new Font("Courier", Font.BOLD, 12);
        normal = new TextStyle(f, Color.black);
        red = new TextStyle(f2, Color.red);
        blue = new TextStyle(f, Color.blue);
        green = new TextStyle(f, Color.green);
        
		// build frame
		setTitle("GNU.FREE: Database Console");
		jLabel1.setText("Results:");
		jButton1.setLabel("Go");
		jLabel2.setText("Command entry:");
	
		FreePanel scrollPanel = new FreePanel("RT Server Results");
		scrollPanel.setInsets(3, 3, 3, 3);
		
		scrollPanel.addComponent( 0, 0, 1, 2, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, sv);
		scrollPanel.addComponent( 1, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jLabel2);
		scrollPanel.addComponent( 2, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jTextField1);
		scrollPanel.addComponent( 2, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton1);
			
		add(scrollPanel, BorderLayout.CENTER);
		setSize(new java.awt.Dimension(472, 315));
	
		// build menu
		mb = new MenuBar();
		setMenuBar(mb);

		// it's a tear-off menu
		m1 = new Menu("Actions", true);
		mb.add(m1);
		item1 = new MenuItem("Close Window");
		m1.add(item1);
		m1.addSeparator();
		item2 = new MenuItem("Exit");
		m1.add(item2);
	}

	public void initComponents() throws Exception
	{

		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});

		m1.addActionListener(this);
		
		item1.setActionCommand("item1");
		item2.setActionCommand("item2");
	}


	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		showMsg(msg);
	}
  
	// Show an warning message (red, bold text)
	protected void showError(String msg) {
		msg += "\n";
		tv.append(msg, red);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg(String msg) {
		msg += "\n";
		tv.append(msg, normal);
	}
	
	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
		RTServer.frame.jButton2.setEnabled(true);
		setVisible(false);
	}
	
	public void jButton1ActionPerformed(java.awt.event.ActionEvent e) {	
	
		String userCommand = jTextField1.getText();
	
		showInfo("Executing: " + userCommand);
		jTextField1.setText("");
	
		DBase.doSQL(userCommand);
	
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand()=="item1") {
			RTServer.frame.jButton2.setEnabled(true);
			setVisible(false);
		} else {
			RTServer.serv.stopServer();
		
			setVisible(false);
			RTServer.frame.setVisible(false);
			dispose();
			System.exit(0);
		}
	}
	
} //EOF class
