/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package ERServer;

import org.apache.log4j.*;
import org.apache.log4j.spi.*;

import java.io.*;

import Free.util.*;
 
/**
 * Implements the <code>org.apache.log4j.Appender</code> interface to provide a secure
 * addition to GNU.FREE logging.<br>
 * <br>
 * This class creates a chain of Message Digests, so that the every log entry creates a
 * digest of itself with the previous entry. Thus altering the log would result in it
 * being inconsistent with the digests unless the entire log was edited.
 *
 * @version 0.1  11 April 2001
 * @author Jason Kitcat
 * @since 1.6
 */
public class SecureAppender implements Appender {

	private String previous_string;
	private String name;
	
	public SecureAppender(String previous_val) {
	
		super();
		previous_string = previous_val; // prime previous_string val
		
	}

	public void doAppend(LoggingEvent le) {
		try {
			FileWriter out = new FileWriter("erserver.sec.log", true);

			out.write(AuthSys.makeDigest(le.message + previous_string) + "\r\n");
			out.close();
		
			previous_string = le.message;
		} catch (Exception e) {
		}
	} //EOF doAppend
	
	
	public void addFilter(Filter newFilter) {
	
		// no filter support needed
	
	}
	
	
	public void clearFilters() {
	
		// no filters
		
	}
	
		
	public void close() {
	
		// the ScreenAppender should never be closed
		// except during valid shutdown thus this
		// method is not needed
	
	}


	public boolean requiresLayout()	{
	
		// we don't need a layout
		return false;		
	
	}

	
	public void setErrorHandler(ErrorHandler errorHandler) {
	
		// not supported
	
	}
	
	
	public void setLayout(Layout l) {
	
		// do nothing as FREE screens
		// have a set layout
		
	}
	
	
	public void activateOptions() {
	
		// do nothing as no
		// ambiguous options
		
	}
	
	
	public String[] getOptionStrings() {
	
		String [] s = new String[1];
		
		s[0] = name;
		
		return s;
	
	}
	
	
	public void setOption(String option, String value) {
	
		name = value;
		
		// no other options so must be that!
		
	}
	
	
	public String getName() {
	
		return name;
		
	}
	

	public void setName(String n) {
	
		name = n;
		
	}
	
} //EOF ScreenAppender