/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
  
package ERServer;

import java.net.*;
import java.io.*;
import java.awt.*;

import Free.awt.*;
import Free.util.*;

import org.apache.log4j.*;

/**
 * Launches the ERServer program and initalises the GUI.
 *
 * The database is also initialised. Additionally the log system
 * is prepared. Logging is done with <code>log4j</code>, more info
 * is available from
 * <a href="http://www.log4j.org">www.log4j.org</a>.
 *
 *
 * @version 1.0  11 April 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class ERServer 
{
	/* SECURITY NOTE: VERY IMPORTANT! */
	// constant to store value being used as FREE port number
	// For security reasons I recommend this is changed every election
//#ifdef INSTALL
	private static final int freePort = 1111;

	/** public and private keys for communications */
//#ifdef INSTALL
	protected static final String rt_public_key = "001101000108008193745AA3A2733EF1140758495439CB4CD188C4F2B5D2FA84C3C533465991257EAFC2BCAC0AC07F1531C97489723A353E7A1C911E687A5E834CD872B534480D8B4F9107E48C994A0D5B68870DE4DC3A51C604572446F166E02B8F234C44158FD373A06CFF30E3BBA2F1E670743D7B855CC2D3EF395D440A702D57013A5146171E4B7C78343FB2DAA47E56C63A2B5CFA57FF8892399F0A7D8E47A0203C687A158D3E0802AE02D3C1EA4AC625B641430FA9A1A50FC095461EED1DF401F93365CD650D02CFD4392BE1349B29900A0DCA648658FAFA3E8C3300E44C705AF3930F5EDF28B5D40C89251F440C9038DD9F533A849965EB71617D91A5CFD5621ED6A5D1";
//#ifdef INSTALL
	protected static final String fc_public_key = "";
//#ifdef INSTALL
	protected static final String pm_public_key = "";
//#ifdef INSTALL
	protected static final String er_private_key = "07FF4A2B93480B1AC5AFDE0CE5FB7A00864BDB41FF1BCFC7FB322EF74BE12299A75B22FA1E026E815BFC5EBA37E50722655F20CD0A79BCA852C649D55D01509BC54C0361ABA4BE7E7ED6F0DE15740355EF04FC570BD2A1CAA43BF7848A1DEE4DAC2086D86ADB935909FC46CF2DEB4D7348BD0D80833ABF45CD43C2A5D92910E96D73AA578D83BFC8787487DC74B3E2940D8B00FA5817416E62A355E154411030520C2CFAAB83C32B09B7DD813FEFD0BEF224A34CD3182484FBD20138E5FD1F036752013192124E42F90C6D4E9CA2EB9AA5AA5E622A4459ABFD224F95F09CC4DA3D6EDA225FAC3035D03314635FAD1AC9E461D96251CC8497C19DA81B7323D1E975210400E50682CE1B0734FEEC88B2AA924C277B958F73324C74489A9B20015EF61A610B433E14EEF6B81A1F127882093AC1E4CCC7CE9380978F2687F9C35B0C6F63C482C7DD1CFB439E12ADF5B26BA9F5E413529272A43E3D732087DBBBDB74663C2E53CD8E22404F60F8DE1DDEC2EACA701DAF7C3724CCA0390FCEFBC3D2B9D9C7BF950400A6CD5010197C85D2DEED12730FE6CA466B3A4042100F1742CB0B7301EEEC2FAC2EE028ABBECC6E44BD277400693601FFEF139814135AC9E87AB1E05C322FCA483F35B7772FA41EE2A62E49768C9ED6BC6A8957328FFF8ED23210FFCBBF1395E55538BAB3AEF29CF1CDA7560896AE1DA8E4B04BD14BD4CD93A7A8A8E040101DAD0400829001A26DBAFC192B567F9F04D1BB49C5BE100D03468E19DC5B600A47485448220E0C820EB5DF8ED6EB24304AF42D233559DBD97FDCD16AC7056BFBF9245CCBF18C48C982BFF91137B94A9669E6B198E33B37DC8B7202E4D66E80506313E9108BE98696897AE1D41A7802DB23D99333D6208F187C0A9AC07FEE484D1AC37EE8";

	// AWT frames
	protected static ERFrame1 frame;
	protected static CryptFrame frame1;
	protected static ERFrame2 frame2;
	
	// Our server
	protected static TCPServer serv;
	
	// logging categories
	protected static Category NORM;
	protected static Category DEV;

	protected ERServer() 
	{
		try {
					
			FreePanel.showSplash(4000);
			
			// initiate GUI
			frame = new ERFrame1();
			frame.initComponents();
			frame1 = new CryptFrame();
			frame1.initComponents();
			frame2 = new ERFrame2();
			frame2.initComponents();
			frame1.setVisible(true);

		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	// Main entry point
	static protected void main(String[] args) 
	{
		new ERServer();

	}

	/**
	 * Fires up the database, logging system and TCP/IP server.
	 *
	 * It also checks to see what mode the software is running in and adapts
	 * the GUI accordingly. Logging is done with <code>log4j</code>, more info
	 * is available from
	 * <a href="http://www.log4j.org/">http://www.log4j.org/</a>.
	 *
	 */
	protected static void startDaemon() {
	
		try {
		
			// init logging system
			ScreenAppender A1 = new ScreenAppender();
			
			// log exists? If so get starting data
			String tempInData = "";
			String secInitString = "STARTING VALUE";
			try {
				BufferedReader t_in = new BufferedReader(new FileReader("erserver.log"));
				String inData = t_in.readLine();
				while (inData!=null) { // get to the last line
					tempInData = inData;
					inData = t_in.readLine();
				}
			 	t_in.close();
			 	inData = tempInData;
			 	
				if (inData!="" || inData!=" ") {  // only change starting value if something there
					// parse that last line
					int i=0;
					int t=0;

					while (inData.charAt(i)!=']') {
						i++;
					}
				
					t = i+5; // skip a safe amount (we know cat data there)
			
					while (inData.charAt(t)!='-') {
						t++;
					}
				
					secInitString = inData.substring(t+2); // got true logging data
				}
			 	
			 } catch (FileNotFoundException fnfe) {
			 	// file not there
			 }
			 
			SecureAppender A2 = new SecureAppender(secInitString);
			PropertyConfigurator.configure("log4j.erserver.properties");			
			NORM = Category.getInstance("NORM");
			NORM.addAppender(A1);
			NORM.addAppender(A2);
			/* comment out the DEV portion to reduce log detail */
			DEV = Category.getInstance("DEV");
			DEV.addAppender(A1);
			DEV.addAppender(A2);
			
			ERServer.NORM.info("GNU.FREE ERServer 0.11 starting up...");
			
			// initialise database
			DBase.init();

			// intialise AuthSys
			AuthKey.init();
			RSAEncrypt.init();
			
			// launch TCPServer services
			serv = new TCPServer();
			serv.startServer(freePort);
			
			ERServer.NORM.info("Server daemon started");
			
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
	
	} //EOF startDaemon

} //EOF Class
