/*
 * GNU.FREE 2002
 *
 * Copyright (c) 1999, 2000, 2001, 2002
 * The Free Software Foundation (www.fsf.org)
 *
 * GNU.FREE Co-ordinator: Jason Kitcat <jeep@free-project.org>
 *
 * GNU site: http://www.gnu.org/software/free/
 * 
 * FREE e-democracy site: http://www.free-project.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (COPYING); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */
 
package ERServer;

import java.awt.*;
import java.awt.event.*;

import Free.awt.*;

/**
 * Main status display screen.
 *
 * @version 0.7 2 April 2001
 * @author Jason Kitcat, Rajagopal C.V
 */
public class ERFrame1 extends Frame implements ActionListener 
{

	ScrollPane jScrollPane1 = new ScrollPane();
    TextView tv;
	ScrollView sv;
	Font f;
	Font f2;
	TextStyle normal;
	TextStyle red;
	TextStyle blue;
	TextStyle green;
	Button jButton1 = new Button();
	Button jButton2 = new Button();
	Button jButton3 = new Button();

	// menu vars
	MenuBar mb;
	Menu m1;
	MenuItem item1, item2, item3, item4;

	public Insets getInsets(){ return new Insets(30, 10, 10, 10);}


	protected ERFrame1() {
	
		// prepare textView
		tv = new TextView(true);
        sv = new ScrollView(tv);
        f = new Font("Courier", Font.PLAIN, 12);
        f2 = new Font("Courier", Font.BOLD, 12);
        normal = new TextStyle(f, Color.black);
        red = new TextStyle(f2, Color.red);
        blue = new TextStyle(f, Color.blue);
        green = new TextStyle(f, Color.green);
        
		// build frame
		jButton1.setLabel("Database Console");
		jButton2.setLabel("Build Keys");
		jButton3.setLabel("Import Users");
		
		FreePanel scrollPanel = new FreePanel("ER Server Messages");
		scrollPanel.setInsets(3, 3, 3, 3);
		
		scrollPanel.addComponent( 0, 0, 1, 3, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 1.0f, sv);
		FreePanel buttonPane = new FreePanel();
		scrollPanel.addComponent( 1, 0, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton1);
		scrollPanel.addComponent( 1, 1, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton2);
		scrollPanel.addComponent( 1, 2, 1, 1, 0, 0, GridBagConstraints.BOTH, 
			1.0f, 0.0f, jButton3);
			
		setTitle("GNU.FREE: ERServer");
		setSize(new java.awt.Dimension(450, 300));
		add(scrollPanel);
		
		// build menu
		mb = new MenuBar();
		setMenuBar(mb);

		// it's a tear-off menu
		m1 = new Menu("Actions", true);
		mb.add(m1);
		item1 = new MenuItem("Import Users");
		m1.add(item1);
		item2 = new MenuItem("Export Keys");
		m1.add(item2);
		item3 = new MenuItem("Database Console");
		m1.add(item3);
		m1.addSeparator();
		item4 = new MenuItem("Exit");
		m1.add(item4);
		
	}

	protected void initComponents() throws Exception
	{

		jButton1.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton1ActionPerformed(e);
			}
		});

		jButton2.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton2ActionPerformed(e);
			}
		});

		jButton3.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButton3ActionPerformed(e);
			}
		});

		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});
		
		m1.addActionListener(this);
		
		item1.setActionCommand("item1");
		item2.setActionCommand("item2");
		item3.setActionCommand("item3");
		item4.setActionCommand("item4");
				
	}
  
	// Show an informational message (black, plain text)
	protected void showInfo(String msg) {
		showMsg(msg);
	}
  
	// Show an warning message (red, bold text)
	protected void showError(String msg) {
		msg += "\n";
		tv.append(msg, red);
	}
	
	// Show a text message using the specified AttributeSet
	protected void showMsg(String msg) {
		msg += "\n";
		tv.append(msg, normal);
	}
  
	void thisWindowClosing(java.awt.event.WindowEvent e)
	{
		ERServer.serv.stopServer();

		setVisible(false);
		dispose();
		System.exit(0);
	}		
	
	public void jButton1ActionPerformed(java.awt.event.ActionEvent e) {
		jButton1.setEnabled(false);
		ERServer.frame2.setVisible(true);
	}
	
	public void jButton2ActionPerformed(java.awt.event.ActionEvent e) {
		try {
			DBase.makeAllKeys();
		} catch (Exception ex) {
			ERServer.NORM.error("Build keys error: " + ex.getMessage());
		}
	}
	
	public void jButton3ActionPerformed(java.awt.event.ActionEvent e) {
		try {
			DBase.importUsers();
		} catch (Exception ex) {
			ERServer.NORM.error("Import users error: " + ex.getMessage());
		}
	}
	
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand()=="item1") {
			jButton3ActionPerformed(e);
		} else if (e.getActionCommand()=="item2") {
			jButton2ActionPerformed(e);
		} else if (e.getActionCommand()=="item3") {
			jButton1ActionPerformed(e);
		} else {
			ERServer.serv.stopServer();

			setVisible(false);
			dispose();
			System.exit(0);
		}
	}

} //EOF class
