/*
 * Decompiled with CFR 0.152.
 */
package Free.awt;

import Free.awt.ScrollView;
import Free.awt.TextRun;
import Free.awt.TextStyle;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class TextView
extends Canvas {
    public static Font DEFAULT_FONT = new Font("Dialog", 0, 10);
    protected Vector _runs;
    protected TextStyle _defaultStyle;
    private Image _image;
    private Graphics _graphics;
    private Dimension _bufferSize = new Dimension(0, 0);
    private int _fullHeight;
    private ScrollView _scrollView;
    protected int _yTranslation = 0;
    private Point _nextDrawPoint = new Point(0, 0);
    private Dimension _scratchDimension = new Dimension(0, 0);
    private boolean _autoScrolling;
    protected int _firstRun = 0;

    public TextView(boolean bl) {
        this._runs = new Vector();
        this.setFont(DEFAULT_FONT);
        this._autoScrolling = bl;
        this.reshape(0, 0, 1024, 768);
        this._defaultStyle = new TextStyle(this.getFont(), Color.black);
    }

    public TextView() {
        this(false);
    }

    public TextStyle getDefaultStyle() {
        return this._defaultStyle;
    }

    public void setScrollView(ScrollView scrollView) {
        this._scrollView = scrollView;
    }

    public void setFont(String string) {
        Font font = this.getFont();
        Font font2 = new Font(string, font.getStyle(), font.getSize());
        this.setFont(font2);
    }

    public void setFontSize(int n) {
        Font font = this.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), n);
        this.setFont(font2);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._defaultStyle = new TextStyle(font, this.getForeground());
    }

    public void append(String string, TextStyle textStyle) {
        if (string.length() == 0) {
            return;
        }
        TextRun textRun = new TextRun(string, textStyle);
        this.append(textRun);
    }

    public synchronized void append(TextRun textRun) {
        this._runs.addElement(textRun);
        this.prepare(textRun);
        if (this._scrollView != null) {
            this._scrollView.boundsChanged();
            if (this._autoScrolling) {
                this._scrollView.scrollToBottom();
            }
        }
        this.repaint();
    }

    public void append(String string) {
        this.append(string, this._defaultStyle);
    }

    public void setYTranslation(int n) {
        this._yTranslation = n;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.renderViewable(graphics);
    }

    public void show() {
        if (this._autoScrolling) {
            this._scrollView.scrollToBottom();
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        boolean bl = this.size().width != n3;
        super.reshape(n, n2, n3, n4);
        if (!this.createBuffer()) {
            return;
        }
        if (bl) {
            this.prepareAll();
        }
        if (this._scrollView != null) {
            this._scrollView.boundsChanged();
            this._scrollView.scrollToBottom();
        }
        this.repaint();
    }

    boolean createBuffer() {
        Dimension dimension = this.size();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return false;
        }
        this._image = this.createImage(dimension.width, dimension.height);
        if (this._image == null) {
            return false;
        }
        if (this._graphics != null) {
            this._graphics.dispose();
        }
        this._graphics = this._image.getGraphics();
        return true;
    }

    public Dimension preferredSize() {
        return new Dimension(this.size().width, this._fullHeight);
    }

    public void prepare(TextRun textRun) {
        int n = this._nextDrawPoint.y;
        textRun.prepare(this.size().width, this._scratchDimension, this._nextDrawPoint);
        this._fullHeight = n + this._scratchDimension.height;
    }

    public synchronized void prepareAll() {
        this._nextDrawPoint.x = 0;
        this._nextDrawPoint.y = 0;
        int n = this.size().width;
        Enumeration enumeration = this._runs.elements();
        while (enumeration.hasMoreElements()) {
            TextRun textRun = (TextRun)enumeration.nextElement();
            this.prepare(textRun);
        }
    }

    public synchronized void renderViewable(Graphics graphics) {
        Dimension dimension = this.size();
        if (this._graphics == null && !this.createBuffer()) {
            return;
        }
        this._graphics.setColor(this.getBackground());
        this._graphics.fillRect(0, 0, dimension.width, dimension.height);
        TextRun textRun = null;
        this._firstRun = -1;
        int n = 0;
        Enumeration enumeration = this._runs.elements();
        while (enumeration.hasMoreElements()) {
            textRun = (TextRun)enumeration.nextElement();
            Rectangle rectangle = textRun.getBoundingRect();
            if (rectangle.y - this._yTranslation + rectangle.height >= 0) {
                if (this._firstRun == -1) {
                    this._firstRun = n;
                }
                if (rectangle.y - this._yTranslation > dimension.height) break;
                textRun.draw(this._graphics, -this._yTranslation);
            }
            ++n;
        }
        graphics.drawImage(this._image, 0, 0, this);
    }
}

