/*
 * Decompiled with CFR 0.152.
 */
package Free.awt;

import Free.awt.Substring;
import Free.awt.TextStyle;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;

public class TextRun {
    private String _text;
    private TextStyle _style;
    private char[] _chars;
    private FontMetrics _fm;
    private int _fmMaxDescent;
    private int _fmMaxAscent;
    private int _fmLeading;
    private int _fmHeight;
    private int[] _fmWidths;
    private Vector _substrings;
    private boolean _newLineFixed;
    private Rectangle _boundingRect = new Rectangle(0, 0, 0, 0);

    public TextRun(String string, TextStyle textStyle) {
        this._text = string;
        this._style = textStyle;
        this._fm = Toolkit.getDefaultToolkit().getFontMetrics(textStyle.getFont());
        this._fmMaxDescent = this._fm.getMaxDescent();
        this._fmMaxAscent = this._fm.getMaxAscent();
        this._fmLeading = this._fm.getLeading();
        this._fmHeight = this._fm.getHeight();
        this._fmWidths = this._fm.getWidths();
        this._chars = this._text.toCharArray();
        this._substrings = new Vector();
    }

    public TextStyle getStyle() {
        return this._style;
    }

    public String getText() {
        return this._text;
    }

    public void setFont(Font font) {
        this._style.setFont(font);
    }

    public Rectangle getBoundingRect() {
        return this._boundingRect;
    }

    int findEnd(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        while (n4 != this._chars.length) {
            if (n5 + this._fmWidths[this._chars[n4]] > n3 || this._chars[n4] == '\n') break;
            n5 += this._fmWidths[this._chars[n4]];
            ++n4;
        }
        if (n4 == this._chars.length) {
            return n4;
        }
        if (this._chars[n4] == '\n') {
            this._newLineFixed = true;
            return n4;
        }
        int n6 = n4;
        while (n4 > n) {
            if (this._chars[n4 - 1] == ' ') {
                return n4;
            }
            --n4;
        }
        return n2 == 0 ? n6 : n4;
    }

    public void prepare(int n, Dimension dimension, Point point) {
        this._substrings.removeAllElements();
        this._boundingRect.x = 0;
        this._boundingRect.y = point.y;
        int n2 = point.x;
        int n3 = point.y;
        if (n == 0) {
            n = 600;
        }
        int n4 = n3 + this._fmMaxAscent;
        int n5 = n2;
        int n6 = 0;
        int n7 = this._chars.length;
        int n8 = 0;
        int n9 = 0;
        do {
            if (this._chars[n6] == '\n') {
                ++n6;
                if (!this._newLineFixed) {
                    n4 += this._fmHeight;
                    n5 = 0;
                } else {
                    this._newLineFixed = false;
                }
                if (n6 == this._chars.length - 1) break;
            }
            n8 = this.findEnd(n6, n5, n);
            n9 = n5 + this._fm.charsWidth(this._chars, n6, n8 - n6);
            this._substrings.addElement(new Substring(n6, n8 - n6, n5, n4));
            n5 = 0;
            if (n8 == n7) continue;
            n4 += this._fmHeight;
            n6 = n8;
        } while (n8 != n7);
        dimension.width = n;
        dimension.height = n4 - n3 + this._fmMaxDescent;
        point.x = n9;
        point.y = n4 - this._fmMaxAscent;
        this._boundingRect.width = dimension.width;
        this._boundingRect.height = dimension.height;
    }

    public boolean contains(int n, int n2, int n3) {
        if (this._boundingRect.inside(n, n2 + n3)) {
            Substring substring = null;
            Enumeration enumeration = this._substrings.elements();
            while (enumeration.hasMoreElements()) {
                Substring substring2 = (Substring)enumeration.nextElement();
                if (n < substring2.xOff || n2 + n3 < substring2.yOff - this._fmHeight) continue;
                substring = substring2;
            }
            if (substring != null && n < substring.xOff + this._fm.stringWidth(new String(this._chars, substring.begin, substring.length))) {
                return true;
            }
        }
        return false;
    }

    public void draw(Graphics graphics, int n) {
        graphics.setColor(this._style.getColor());
        graphics.setFont(this._style.getFont());
        Enumeration enumeration = this._substrings.elements();
        while (enumeration.hasMoreElements()) {
            Substring substring = (Substring)enumeration.nextElement();
            graphics.drawChars(this._chars, substring.begin, substring.length, substring.xOff, substring.yOff + n);
        }
    }

    public String toString() {
        return "TextRun[\"" + this._text + "\"]; Bounds = " + this._boundingRect;
    }
}

