/*
 * Decompiled with CFR 0.152.
 */
package Free.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class ProgressBar
extends Canvas {
    private int progressWidth;
    private int progressHeight;
    private float percentage;
    private Image offscreenImg;
    private Graphics offscreenG;
    private Color progressColor = Color.red;
    private Color progressBackground = Color.white;

    public ProgressBar(int n, int n2) {
        Font font = new Font("Courier", 1, 15);
        this.setFont(font);
        this.progressWidth = n;
        this.progressHeight = n2;
        this.resize(n, n2);
    }

    public ProgressBar(int n, int n2, Color color, Color color2, Color color3) {
        Font font = new Font("Courier", 1, 15);
        this.setFont(font);
        this.progressWidth = n;
        this.progressHeight = n2;
        this.progressColor = color2;
        this.progressBackground = color3;
        this.resize(n, n2);
        this.setBackground(color);
    }

    public void updateBar(float f) {
        this.percentage = f;
        this.repaint();
    }

    public void setCanvasColor(Color color) {
        this.setBackground(color);
    }

    public void setProgressColor(Color color) {
        this.progressColor = color;
    }

    public void setBackGroundColor(Color color) {
        this.progressBackground = color;
    }

    public void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 4;
        if (this.offscreenImg == null) {
            this.offscreenImg = this.createImage(this.progressWidth - n3, this.progressHeight - n3);
        }
        this.offscreenG = this.offscreenImg.getGraphics();
        n = this.offscreenImg.getWidth(this);
        n2 = this.offscreenImg.getHeight(this);
        this.offscreenG.setColor(this.progressBackground);
        this.offscreenG.fillRect(0, 0, n, n2);
        this.offscreenG.setColor(this.progressColor);
        this.offscreenG.fillRect(0, 0, (int)((float)n * this.percentage), n2);
        this.offscreenG.drawString(String.valueOf(Integer.toString((int)(this.percentage * 100.0f))) + "%", n / 2 - 8, n2 / 2 + 5);
        this.offscreenG.clipRect(0, 0, (int)((float)n * this.percentage), n2);
        this.offscreenG.setColor(this.progressBackground);
        this.offscreenG.drawString(String.valueOf(Integer.toString((int)(this.percentage * 100.0f))) + "%", n / 2 - 8, n2 / 2 + 5);
        graphics.setColor(this.progressBackground);
        graphics.draw3DRect(this.size().width / 2 - this.progressWidth / 2, 0, this.progressWidth - 1, this.progressHeight - 1, false);
        graphics.drawImage(this.offscreenImg, n3 / 2, n3 / 2, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

