/*
 * Decompiled with CFR 0.152.
 */
package Free.awt;

import Free.awt.RxImageLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;

public class FreePanel
extends Panel {
    public static final int TEXT_OFFSET = 5;
    protected int style;
    protected int thickness = 2;
    protected int myWidth;
    protected int myHeight;
    protected String text = "";
    GridBagLayout gbl = new GridBagLayout();
    public static final int RAISED = 1;
    int top = 2;
    int left = 2;
    int bottom = 2;
    int right = 2;
    Color backgroundColor;
    Color lighterColor;
    Color darkerColor;
    int anchor = 10;

    public FreePanel() {
    }

    public FreePanel(int n) {
        this.style = n;
    }

    public FreePanel(String string) {
        this.style = 1;
        this.text = string;
    }

    public void addComponent(int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.ipady = n6;
        gridBagConstraints.ipadx = n5;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n3;
        gridBagConstraints.fill = n7;
        gridBagConstraints.anchor = this.anchor;
        gridBagConstraints.weightx = f;
        gridBagConstraints.weighty = f2;
        gridBagConstraints.insets = new Insets(this.top, this.left, this.bottom, this.right);
        this.gbl.setConstraints(component, gridBagConstraints);
        this.setLayout(this.gbl);
        this.add(component);
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.top = n;
        this.left = n2;
        this.bottom = n3;
        this.right = n4;
    }

    public void setAnchor(int n) {
        this.anchor = n;
    }

    public void setGridWidths(int[] nArray) {
        this.gbl.columnWidths = nArray;
    }

    public void setGridHeights(int[] nArray) {
        this.gbl.rowHeights = nArray;
    }

    public void addNotify() {
        super.addNotify();
        this.backgroundColor = this.getParent().getBackground();
        this.lighterColor = this.backgroundColor.brighter();
        this.darkerColor = this.backgroundColor.darker();
        this.getMetrics();
    }

    public Insets getInsets() {
        FontMetrics fontMetrics;
        int n;
        int n2 = n = this.thickness + 1;
        int n3 = n;
        int n4 = n;
        if (this.text != "" && (fontMetrics = this.getFontMetrics(this.getFont())) != null) {
            n2 += fontMetrics.getHeight() / 2 + 1;
        }
        return new Insets(n2, n, n, n);
    }

    public void getMetrics() {
        Dimension dimension = this.getMinimumSize();
        this.setSize(dimension.width, dimension.height);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.getSize().width < 1) {
            this.getMetrics();
        }
        if (this.style == 1) {
            this.drawRaisedFrame(graphics);
            if (this.text != "" && this.text != null) {
                this.printCaption(graphics);
            }
        }
    }

    public void drawRaisedFrame(Graphics graphics) {
        int n = 0;
        Dimension dimension = this.getSize();
        if (this.text != "") {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = fontMetrics.getHeight() / 2;
        }
        int n2 = 0;
        int n3 = 1;
        while (n2 < this.thickness) {
            graphics.setColor(this.lighterColor);
            graphics.fillRect(n2, n2 + n, dimension.width - 2 * n2, 1);
            graphics.fillRect(n2, n2 + n, 1, dimension.height - (2 * n2 + 1));
            graphics.setColor(this.darkerColor);
            graphics.fillRect(n2, dimension.height - (n2 + 1), dimension.width - 2 * n2, 1);
            graphics.fillRect(dimension.width - (n2 + 1), n2 + n, 1, dimension.height - (2 * n2 + 1));
            ++n2;
            n3 += 2;
        }
    }

    public void printCaption(Graphics graphics) {
        Color color = graphics.getColor();
        int n = 0;
        int n2 = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Dimension dimension = this.getSize();
        Font font = graphics.getFont();
        graphics.setFont(new Font(font.getName(), 1, font.getSize()));
        int n3 = fontMetrics.charWidth('i');
        n = this.thickness + 5 + n3;
        n2 = 0;
        graphics.setColor(this.getBackground());
        graphics.fillRect(n, n2, fontMetrics.stringWidth(this.text) + n3 * 2, fontMetrics.getHeight());
        graphics.setColor(Color.black);
        graphics.drawString(this.text, n += n3, n2 += fontMetrics.getHeight() - fontMetrics.getDescent() - 1);
        graphics.setColor(color);
        graphics.setFont(font);
    }

    public static void showSplash(int n) {
        Window window = new Window(new Frame());
        int n2 = 400;
        int n3 = 200;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = (dimension.width - n2) / 2;
        int n5 = (dimension.height - n3) / 2;
        ((Component)window).setBounds(n4, n5, n2, n3);
        RxImageLabel rxImageLabel = new RxImageLabel("splash");
        window.add((Component)rxImageLabel, "Center");
        ((Component)window).setVisible(true);
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {}
        ((Component)window).setVisible(false);
    }
}

