/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.lang.reflect.Field;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.postgresql.Connection;
import org.postgresql.util.PSQLException;

public class Serialize {
    protected Connection conn;
    protected String tableName;
    protected String className;
    protected Class ourClass;
    private static final String[][] tp = new String[][]{{"boolean", "int1"}, {"double", "float8"}, {"float", "float4"}, {"int", "int4"}, {"long", "int4"}, {"short", "int2"}, {"java.lang.String", "text"}, {"java.lang.Integer", "int4"}, {"java.lang.Float", "float4"}, {"java.lang.Double", "float8"}, {"java.lang.Short", "int2"}};

    public Serialize(Connection c, String type) throws SQLException {
        try {
            this.conn = c;
            this.tableName = type.toLowerCase();
            this.className = Serialize.toClassName(type);
            this.ourClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PSQLException("postgresql.serial.noclass", (Object)type);
        }
        boolean status = false;
        ResultSet rs = this.conn.ExecSQL("select typname from pg_type,pg_class where typname=relname and typname='" + type + "'");
        if (rs != null) {
            if (rs.next()) {
                status = true;
            }
            rs.close();
        }
        if (!status) {
            throw new PSQLException("postgresql.serial.table", (Object)type);
        }
    }

    public Object fetch(int oid) throws SQLException {
        try {
            Object obj = this.ourClass.newInstance();
            Field[] f = this.ourClass.getDeclaredFields();
            boolean hasOID = false;
            int oidFIELD = -1;
            StringBuffer sb = new StringBuffer("select");
            int sep = 32;
            int i = 0;
            while (i < f.length) {
                String n = f[i].getName();
                if (n.equals("oid")) {
                    hasOID = true;
                    oidFIELD = i;
                }
                sb.append((char)sep);
                sb.append(n);
                sep = 44;
                ++i;
            }
            sb.append(" from ");
            sb.append(this.tableName);
            sb.append(" where oid=");
            sb.append(oid);
            DriverManager.println("store: " + sb.toString());
            ResultSet rs = this.conn.ExecSQL(sb.toString());
            if (rs != null) {
                if (rs.next()) {
                    int i2 = 0;
                    while (i2 < f.length) {
                        f[i2].set(obj, rs.getObject(i2 + 1));
                        ++i2;
                    }
                }
            } else {
                throw new PSQLException("postgresql.unexpected");
            }
            rs.close();
            return obj;
        }
        catch (IllegalAccessException iae) {
            throw new SQLException(iae.toString());
        }
        catch (InstantiationException ie) {
            throw new SQLException(ie.toString());
        }
    }

    public int store(Object o) throws SQLException {
        try {
            Field[] f = this.ourClass.getDeclaredFields();
            boolean hasOID = false;
            int oidFIELD = -1;
            boolean update = false;
            int i = 0;
            while (i < f.length) {
                String n = f[i].getName();
                if (n.equals("oid")) {
                    hasOID = true;
                    oidFIELD = i;
                    update = f[i].getInt(o) > 0;
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer(update ? "update " + this.tableName + " set" : "insert into " + this.tableName + " values ");
            int sep = update ? 32 : 40;
            int i2 = 0;
            while (i2 < f.length) {
                String n = f[i2].getName();
                sb.append((char)sep);
                sb.append(n);
                sep = 44;
                if (update) {
                    sb.append('=');
                    if (f[i2].getType().getName().equals("java.lang.String")) {
                        sb.append('\'');
                        sb.append(f[i2].get(o).toString());
                        sb.append('\'');
                    } else {
                        sb.append(f[i2].get(o).toString());
                    }
                }
                ++i2;
            }
            if (!update) {
                sb.append(") values ");
                sep = 40;
                int i3 = 0;
                while (i3 < f.length) {
                    String n = f[i3].getName();
                    if (f[i3].getType().getName().equals("java.lang.String")) {
                        sb.append('\'');
                        sb.append(f[i3].get(o).toString());
                        sb.append('\'');
                    } else {
                        sb.append(f[i3].get(o).toString());
                    }
                    ++i3;
                }
                sb.append(')');
            }
            DriverManager.println("store: " + sb.toString());
            ResultSet rs = this.conn.ExecSQL(sb.toString());
            if (rs != null) {
                rs.close();
            }
            int oid = 0;
            if (hasOID) {
                f[oidFIELD].setInt(o, oid);
            }
            return oid;
        }
        catch (IllegalAccessException iae) {
            throw new SQLException(iae.toString());
        }
    }

    public static void create(Connection con, Object o) throws SQLException {
        Serialize.create(con, o.getClass());
    }

    public static void create(Connection con, Class c) throws SQLException {
        if (c.isInterface()) {
            throw new PSQLException("postgresql.serial.interface");
        }
        String tableName = Serialize.toPostgreSQL(c.getName());
        ResultSet rs = con.ExecSQL("select relname from pg_class where relname = '" + tableName + "'");
        if (!rs.next()) {
            DriverManager.println("found " + rs.getString(1));
            StringBuffer sb = new StringBuffer("create table ");
            sb.append(tableName);
            int sep = 40;
            Field[] fields = c.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Class<?> type = fields[i].getType();
                if (!fields[i].getName().equals("oid")) {
                    sb.append((char)sep);
                    sb.append(fields[i].getName());
                    sb.append(' ');
                    sep = 44;
                    if (!type.isArray()) {
                        String n = fields[i].getType().getName();
                        int j = 0;
                        while (j < tp.length && !tp[j][0].equals(n)) {
                            ++j;
                        }
                        if (j < tp.length) {
                            sb.append(tp[j][1]);
                        } else {
                            Serialize.create(con, fields[i].getType());
                            sb.append(Serialize.toPostgreSQL(n));
                        }
                    }
                }
                ++i;
            }
            sb.append(")");
            DriverManager.println("Serialize.create:" + sb);
            con.ExecSQL(sb.toString());
            rs.close();
        } else {
            DriverManager.println("Serialize.create: table " + tableName + " exists, skipping");
        }
    }

    public static String toPostgreSQL(String name) throws SQLException {
        if ((name = name.toLowerCase()).indexOf("_") > -1) {
            throw new PSQLException("postgresql.serial.underscore");
        }
        if (name.length() > 32) {
            throw new PSQLException("postgresql.serial.namelength", (Object)name, new Integer(name.length()));
        }
        return name.replace('.', '_');
    }

    public static String toClassName(String name) throws SQLException {
        name = name.toLowerCase();
        return name.replace('_', '.');
    }
}

