/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PSQLException
extends SQLException {
    private String message;
    static ResourceBundle bundle;

    public PSQLException(String error) {
        this.translate(error, null);
    }

    public PSQLException(String error, Object[] args) {
        this.translate(error, args);
    }

    public PSQLException(String error, Object arg) {
        Object[] argv = new Object[]{arg};
        this.translate(error, argv);
    }

    public PSQLException(String error, Object arg1, Object arg2) {
        Object[] argv = new Object[]{arg1, arg2};
        this.translate(error, argv);
    }

    private void translate(String id, Object[] args) {
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle("org.postgresql.errors");
            }
            catch (MissingResourceException missingResourceException) {}
        }
        this.message = null;
        try {
            this.message = bundle.getString(id);
        }
        catch (MissingResourceException missingResourceException) {
            this.message = id;
        }
        if (args != null) {
            this.message = MessageFormat.format(this.message, args);
        }
    }

    public String getLocalizedMessage() {
        return this.message;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.message;
    }
}

