/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.postgresql.ResultSet;
import org.postgresql.jdbc1.Connection;
import org.postgresql.util.PSQLException;

public class Statement
implements java.sql.Statement {
    Connection connection;
    java.sql.ResultSet result;
    SQLWarning warnings;
    int timeout;
    boolean escapeProcessing = true;

    public Statement(Connection c) {
        this.connection = c;
    }

    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        while (this.result != null && !((ResultSet)((Object)this.result)).reallyResultSet()) {
            this.result = ((ResultSet)((Object)this.result)).getNext();
        }
        if (this.result == null) {
            throw new PSQLException("postgresql.stat.noresult");
        }
        return this.result;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            throw new PSQLException("postgresql.stat.result");
        }
        return this.getUpdateCount();
    }

    public void close() throws SQLException {
        this.result = null;
    }

    public int getMaxFieldSize() throws SQLException {
        return 8192;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new PSQLException("postgresql.stat.maxfieldsize");
    }

    public int getMaxRows() throws SQLException {
        return this.connection.maxrows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.connection.maxrows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.timeout = seconds;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void setCursorName(String name) throws SQLException {
        this.connection.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        this.result = this.connection.ExecSQL(sql);
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        return this.result;
    }

    public int getUpdateCount() throws SQLException {
        if (this.result == null) {
            return -1;
        }
        if (((ResultSet)((Object)this.result)).reallyResultSet()) {
            return -1;
        }
        return ((ResultSet)((Object)this.result)).getResultCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.result = ((ResultSet)((Object)this.result)).getNext();
        return this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet();
    }

    public String getResultStatusString() {
        if (this.result == null) {
            return null;
        }
        return ((ResultSet)((Object)this.result)).getStatusString();
    }
}

