/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.postgresql.Field;
import org.postgresql.jdbc1.Connection;
import org.postgresql.jdbc1.ResultSetMetaData;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PSQLException;

public class ResultSet
extends org.postgresql.ResultSet
implements java.sql.ResultSet {
    public ResultSet(Connection conn, Field[] fields, Vector tuples, String status, int updateCount) {
        super(conn, fields, tuples, status, updateCount);
    }

    public boolean next() throws SQLException {
        if (++this.current_row >= this.rows.size()) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    public String getString(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return new String(this.this_row[columnIndex - 1]);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            char c = s.charAt(0);
            return c == 't' || c == 'T';
        }
        return false;
    }

    public byte getByte(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Byte.parseByte(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbyte", (Object)s);
            }
        }
        return 0;
    }

    public short getShort(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Short.parseShort(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badshort", (Object)s);
            }
        }
        return 0;
    }

    public int getInt(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.badint", (Object)s);
            }
        }
        return 0;
    }

    public long getLong(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badlong", (Object)s);
            }
        }
        return 0L;
    }

    public float getFloat(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Float.valueOf(s).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badfloat", (Object)s);
            }
        }
        return 0.0f;
    }

    public double getDouble(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.baddouble", (Object)s);
            }
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            BigDecimal val;
            try {
                val = new BigDecimal(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)s);
            }
            try {
                return val.setScale(scale);
            }
            catch (ArithmeticException arithmeticException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)s);
            }
        }
        return null;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (!this.wasNullFlag && this.fields[columnIndex - 1].getOID() == 26) {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            LargeObject lob = lom.open(this.getInt(columnIndex));
            byte[] buf = lob.read(lob.size());
            lob.close();
            return buf;
        }
        return this.this_row[columnIndex - 1];
    }

    public Date getDate(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return new Date(df.parse(s).getTime());
        }
        catch (ParseException e) {
            throw new PSQLException("postgresql.res.baddate", new Integer(e.getErrorOffset()), s);
        }
    }

    public Time getTime(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                if (s.length() != 5 && s.length() != 8) {
                    throw new NumberFormatException("Wrong Length!");
                }
                int hr = Integer.parseInt(s.substring(0, 2));
                int min = Integer.parseInt(s.substring(3, 5));
                int sec = s.length() == 5 ? 0 : Integer.parseInt(s.substring(6));
                return new Time(hr, min, sec);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badtime", (Object)s);
            }
        }
        return null;
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:sszzz");
        try {
            return new Timestamp(df.parse(s).getTime());
        }
        catch (ParseException e) {
            throw new PSQLException("postgresql.res.badtimestamp", new Integer(e.getErrorOffset()), s);
        }
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] b = this.getBytes(columnIndex);
        if (b != null) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public String getCursorName() throws SQLException {
        return this.connection.getCursorName();
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.rows, this.fields);
    }

    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: {
                return new Boolean(this.getBoolean(columnIndex));
            }
            case 5: {
                return new Integer(this.getInt(columnIndex));
            }
            case 4: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: {
                return this.getBigDecimal(columnIndex, field.mod - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
        }
        return this.connection.getObject(field.getTypeName(), this.getString(columnIndex));
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].name.equalsIgnoreCase(columnName)) {
                return i + 1;
            }
            ++i;
        }
        throw new PSQLException("postgresql.res.colname", (Object)columnName);
    }
}

