/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.jdbc1.Connection;
import org.postgresql.jdbc1.Statement;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    String sql;
    String[] templateStrings;
    String[] inStrings;
    Connection connection;

    public PreparedStatement(Connection connection, String sql) throws SQLException {
        super(connection);
        Vector<String> v = new Vector<String>();
        boolean inQuotes = false;
        int lastParmEnd = 0;
        this.sql = sql;
        this.connection = connection;
        int i = 0;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (c == '\'') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == '?' && !inQuotes) {
                v.addElement(sql.substring(lastParmEnd, i));
                lastParmEnd = i + 1;
            }
            ++i;
        }
        v.addElement(sql.substring(lastParmEnd, sql.length()));
        this.templateStrings = new String[v.size()];
        this.inStrings = new String[v.size() - 1];
        this.clearParameters();
        i = 0;
        while (i < this.templateStrings.length) {
            this.templateStrings[i] = (String)v.elementAt(i);
            ++i;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.inStrings.length) {
            if (this.inStrings[i] == null) {
                throw new PSQLException("postgresql.prep.param", new Integer(i + 1));
            }
            s.append(this.templateStrings[i]);
            s.append(this.inStrings[i]);
            ++i;
        }
        s.append(this.templateStrings[this.inStrings.length]);
        return super.executeQuery(s.toString());
    }

    public int executeUpdate() throws SQLException {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.inStrings.length) {
            if (this.inStrings[i] == null) {
                throw new PSQLException("postgresql.prep.param", new Integer(i + 1));
            }
            s.append(this.templateStrings[i]);
            s.append(this.inStrings[i]);
            ++i;
        }
        s.append(this.templateStrings[this.inStrings.length]);
        return super.executeUpdate(s.toString());
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.set(parameterIndex, "null");
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.set(parameterIndex, x ? "'t'" : "'f'");
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.set(parameterIndex, new Integer(x).toString());
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.set(parameterIndex, new Integer(x).toString());
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.set(parameterIndex, new Integer(x).toString());
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.set(parameterIndex, new Long(x).toString());
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.set(parameterIndex, new Float(x).toString());
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.set(parameterIndex, new Double(x).toString());
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.set(parameterIndex, x.toString());
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.set(parameterIndex, "null");
        } else {
            StringBuffer b = new StringBuffer();
            b.append('\'');
            int i = 0;
            while (i < x.length()) {
                char c = x.charAt(i);
                if (c == '\\' || c == '\'') {
                    b.append('\\');
                }
                b.append(c);
                ++i;
            }
            b.append('\'');
            this.set(parameterIndex, b.toString());
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        LargeObject lob = lom.open(oid);
        lob.write(x);
        lob.close();
        this.setInt(parameterIndex, oid);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        SimpleDateFormat df = new SimpleDateFormat("''yyyy-MM-dd''");
        this.set(parameterIndex, df.format(x));
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.set(parameterIndex, "'" + x.toString() + "'");
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.set(parameterIndex, "'" + x.toString() + "'");
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented();
    }

    public void clearParameters() throws SQLException {
        int i = 0;
        while (i < this.inStrings.length) {
            this.inStrings[i] = null;
            ++i;
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        switch (targetSqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (x instanceof Boolean) {
                    this.set(parameterIndex, (Boolean)x != false ? "1" : "0");
                    break;
                }
                this.set(parameterIndex, x.toString());
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, x.toString());
                break;
            }
            case 91: {
                this.setDate(parameterIndex, (Date)x);
                break;
            }
            case 92: {
                this.setTime(parameterIndex, (Time)x);
                break;
            }
            case 93: {
                this.setTimestamp(parameterIndex, (Timestamp)x);
                break;
            }
            case 1111: {
                this.setString(parameterIndex, ((PGobject)x).getValue());
                break;
            }
            default: {
                throw new PSQLException("postgresql.prep.type");
            }
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof PGobject) {
            this.setString(parameterIndex, ((PGobject)x).getValue());
        } else {
            this.setLong(parameterIndex, this.connection.putObject(x));
        }
    }

    public boolean execute() throws SQLException {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.inStrings.length) {
            if (this.inStrings[i] == null) {
                throw new PSQLException("postgresql.prep.param", new Integer(i + 1));
            }
            s.append(this.templateStrings[i]);
            s.append(this.inStrings[i]);
            ++i;
        }
        s.append(this.templateStrings[this.inStrings.length]);
        return super.execute(s.toString());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.inStrings.length) {
            if (this.inStrings[i] == null) {
                s.append('?');
            } else {
                s.append(this.templateStrings[i]);
            }
            s.append(this.inStrings[i]);
            ++i;
        }
        s.append(this.templateStrings[this.inStrings.length]);
        return s.toString();
    }

    private void set(int paramIndex, String s) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.inStrings.length) {
            throw new PSQLException("postgresql.prep.range");
        }
        this.inStrings[paramIndex - 1] = s;
    }
}

