/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.postgresql.Field;
import org.postgresql.jdbc1.DatabaseMetaData;
import org.postgresql.jdbc1.PreparedStatement;
import org.postgresql.jdbc1.ResultSet;
import org.postgresql.jdbc1.Statement;
import org.postgresql.util.PSQLException;

public class Connection
extends org.postgresql.Connection
implements java.sql.Connection {
    protected DatabaseMetaData metadata;

    public java.sql.Statement createStatement() throws SQLException {
        return new Statement(this);
    }

    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return new PreparedStatement(this, sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new PSQLException("postgresql.con.call");
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (autoCommit) {
            this.ExecSQL("end");
        } else {
            this.ExecSQL("begin");
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        this.ExecSQL("commit");
        this.autoCommit = true;
        this.ExecSQL("begin");
        this.autoCommit = false;
    }

    public void rollback() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        this.ExecSQL("rollback");
        this.autoCommit = true;
        this.ExecSQL("begin");
        this.autoCommit = false;
    }

    public void close() throws SQLException {
        if (this.pg_stream != null) {
            try {
                this.pg_stream.close();
            }
            catch (IOException iOException) {}
            this.pg_stream = null;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.pg_stream == null;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        if (this.metadata == null) {
            this.metadata = new DatabaseMetaData(this);
        }
        return this.metadata;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        String q = "SET TRANSACTION ISOLATION LEVEL";
        switch (level) {
            case 2: {
                this.ExecSQL(String.valueOf(q) + " READ COMMITTED");
                return;
            }
            case 8: {
                this.ExecSQL(String.valueOf(q) + " SERIALIZABLE");
                return;
            }
        }
        throw new PSQLException("postgresql.con.isolevel", new Integer(level));
    }

    public int getTransactionIsolation() throws SQLException {
        this.ExecSQL("show xactisolevel");
        SQLWarning w = this.getWarnings();
        if (w != null) {
            if (w.getMessage().indexOf("READ COMMITTED") != -1) {
                return 2;
            }
            if (w.getMessage().indexOf("READ UNCOMMITTED") != -1) {
                return 1;
            }
            if (w.getMessage().indexOf("REPEATABLE READ") != -1) {
                return 4;
            }
            if (w.getMessage().indexOf("SERIALIZABLE") != -1) {
                return 8;
            }
        }
        return 2;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    protected java.sql.ResultSet getResultSet(org.postgresql.Connection conn, Field[] fields, Vector tuples, String status, int updateCount) throws SQLException {
        return new ResultSet((Connection)conn, fields, tuples, status, updateCount);
    }
}

