/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] points;

    public PGpolygon(PGpoint[] points) {
        this();
        this.points = points;
    }

    public PGpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGpolygon() {
        this.setType("polygon");
    }

    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        int p = 0;
        while (p < npoints) {
            this.points[p] = new PGpoint(t.getToken(p));
            ++p;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGpolygon) {
            PGpolygon p = (PGpolygon)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            int i = 0;
            while (i < this.points.length) {
                if (!this.points[i].equals(p.points[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        PGpoint[] ary = new PGpoint[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            ary[i] = (PGpoint)this.points[i].clone();
            ++i;
        }
        return new PGpolygon(ary);
    }

    public String getValue() {
        StringBuffer b = new StringBuffer();
        b.append("(");
        int p = 0;
        while (p < this.points.length) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
            ++p;
        }
        b.append(")");
        return b.toString();
    }
}

