/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.fastpath;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresql.Connection;
import org.postgresql.PG_Stream;
import org.postgresql.fastpath.FastpathArg;
import org.postgresql.util.PSQLException;

public class Fastpath {
    protected Hashtable func = new Hashtable();
    protected Connection conn;
    protected PG_Stream stream;

    public Fastpath(Connection conn, PG_Stream stream) {
        this.conn = conn;
        this.stream = stream;
    }

    public Object fastpath(int fnid, boolean resulttype, FastpathArg[] args) throws SQLException {
        PG_Stream pG_Stream = this.stream;
        synchronized (pG_Stream) {
            int in;
            try {
                this.stream.SendInteger(70, 1);
                this.stream.SendInteger(0, 1);
                this.stream.SendInteger(fnid, 4);
                this.stream.SendInteger(args.length, 4);
                int i = 0;
                while (i < args.length) {
                    args[i].send(this.stream);
                    ++i;
                }
                this.stream.flush();
            }
            catch (IOException ioe) {
                throw new PSQLException("postgresql.fp.send", new Integer(fnid), (Object)ioe);
            }
            Object result = null;
            block13: while (true) {
                in = this.stream.ReceiveChar();
                switch (in) {
                    case 86: 
                    case 90: {
                        continue block13;
                    }
                    case 71: {
                        int sz = this.stream.ReceiveIntegerR(4);
                        if (resulttype) {
                            result = new Integer(this.stream.ReceiveIntegerR(sz));
                            continue block13;
                        }
                        byte[] buf = new byte[sz];
                        this.stream.Receive(buf, 0, sz);
                        result = buf;
                        continue block13;
                    }
                    case 69: {
                        throw new PSQLException("postgresql.fp.error", (Object)this.stream.ReceiveString(4096));
                    }
                    case 78: {
                        this.conn.addWarning(this.stream.ReceiveString(4096));
                        continue block13;
                    }
                    case 48: {
                        Integer n = result;
                        Object var6_12 = null;
                        return n;
                    }
                }
                break;
            }
            throw new PSQLException("postgresql.fp.protocol", new Character((char)in));
        }
    }

    public Object fastpath(String name, boolean resulttype, FastpathArg[] args) throws SQLException {
        return this.fastpath(this.getID(name), resulttype, args);
    }

    public int getInteger(String name, FastpathArg[] args) throws SQLException {
        Integer i = (Integer)this.fastpath(name, true, args);
        if (i == null) {
            throw new PSQLException("postgresql.fp.expint", (Object)name);
        }
        return i;
    }

    public byte[] getData(String name, FastpathArg[] args) throws SQLException {
        return (byte[])this.fastpath(name, false, args);
    }

    public void addFunction(String name, int fnid) {
        this.func.put(name, new Integer(fnid));
    }

    public void addFunctions(ResultSet rs) throws SQLException {
        while (rs.next()) {
            this.func.put(rs.getString(1), new Integer(rs.getInt(2)));
        }
    }

    public int getID(String name) throws SQLException {
        Integer id = (Integer)this.func.get(name);
        if (id == null) {
            throw new PSQLException("postgresql.fp.unknown", (Object)name);
        }
        return id;
    }
}

