/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.postgresql.Connection;
import org.postgresql.Field;

public abstract class ResultSet {
    protected Vector rows;
    protected Field[] fields;
    protected String status;
    protected int updateCount;
    protected int current_row;
    protected byte[][] this_row;
    protected Connection connection;
    protected SQLWarning warnings;
    protected boolean wasNullFlag = false;
    protected ResultSet next;

    public ResultSet(Connection conn, Field[] fields, Vector tuples, String status, int updateCount) {
        this.connection = conn;
        this.fields = fields;
        this.rows = tuples;
        this.status = status;
        this.updateCount = updateCount;
        this.this_row = null;
        this.current_row = -1;
    }

    public boolean reallyResultSet() {
        return this.fields != null;
    }

    public java.sql.ResultSet getNext() {
        return (java.sql.ResultSet)((Object)this.next);
    }

    public void append(ResultSet r) {
        if (this.next == null) {
            this.next = r;
        } else {
            this.next.append(r);
        }
    }

    public int getResultCount() {
        return this.updateCount;
    }

    public int getTupleCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.fields.length;
    }

    public String getStatusString() {
        return this.status;
    }

    public int getColumnOID(int field) {
        return this.fields[field - 1].getOID();
    }

    public abstract void close() throws SQLException;

    public abstract boolean next() throws SQLException;

    public abstract String getString(int var1) throws SQLException;
}

