/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.sql.SQLException;
import org.postgresql.Connection;
import org.postgresql.ResultSet;
import org.postgresql.util.PSQLException;

public class Field {
    public int length;
    public int oid;
    public int mod;
    public String name;
    protected Connection conn;
    public int sql_type = -1;
    public String type_name;
    private static final String[] types = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bool", "date", "time", "abstime", "timestamp"};
    private static final int[] typei = new int[]{5, 4, 4, -5, 3, 3, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -7, 91, 92, 93, 93};

    public Field(Connection conn, String name, int oid, int length, int mod) {
        this.conn = conn;
        this.name = name;
        this.oid = oid;
        this.length = length;
        this.mod = mod;
    }

    public Field(Connection conn, String name, int oid, int length) {
        this(conn, name, oid, length, 0);
    }

    public int getOID() {
        return this.oid;
    }

    public int getSQLType() throws SQLException {
        if (this.sql_type == -1) {
            this.type_name = (String)this.conn.fieldCache.get(new Integer(this.oid));
            if (this.type_name == null) {
                ResultSet result = (ResultSet)((Object)this.conn.ExecSQL("select typname from pg_type where oid = " + this.oid));
                if (result.getColumnCount() != 1 || result.getTupleCount() != 1) {
                    throw new PSQLException("postgresql.unexpected");
                }
                result.next();
                this.type_name = result.getString(1);
                this.conn.fieldCache.put(new Integer(this.oid), this.type_name);
                result.close();
            }
            this.sql_type = Field.getSQLType(this.type_name);
        }
        return this.sql_type;
    }

    public static int getSQLType(String type_name) {
        int sql_type = 1111;
        int i = 0;
        while (i < types.length) {
            if (type_name.equals(types[i])) {
                sql_type = typei[i];
            }
            ++i;
        }
        return sql_type;
    }

    public String getTypeName() throws SQLException {
        int sql = this.getSQLType();
        return this.type_name;
    }
}

