/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.PG_Stream;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.Serialize;
import org.postgresql.util.UnixCrypt;

public abstract class Connection {
    public PG_Stream pg_stream;
    public int maxrows;
    private String PG_HOST;
    private int PG_PORT;
    private String PG_USER;
    private String PG_PASSWORD;
    private String PG_DATABASE;
    private boolean PG_STATUS;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor;
    protected static final int PG_PROTOCOL_LATEST_MAJOR = 2;
    protected static final int PG_PROTOCOL_LATEST_MINOR = 0;
    private static final int SM_DATABASE = 64;
    private static final int SM_USER = 32;
    private static final int SM_OPTIONS = 64;
    private static final int SM_UNUSED = 64;
    private static final int SM_TTY = 64;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private String salt;
    public Hashtable fieldCache = new Hashtable();
    public SQLWarning firstWarning;
    public int pid;
    public int ckey;
    private Fastpath fastpath;
    private LargeObjectManager largeobject;
    private Hashtable objectTypes = new Hashtable();
    private static final String[][] defaultObjectTypes = new String[][]{{"box", "postgresql.geometric.PGbox"}, {"circle", "postgresql.geometric.PGcircle"}, {"line", "postgresql.geometric.PGline"}, {"lseg", "postgresql.geometric.PGlseg"}, {"path", "postgresql.geometric.PGpath"}, {"point", "postgresql.geometric.PGpoint"}, {"polygon", "postgresql.geometric.PGpolygon"}, {"money", "postgresql.util.PGmoney"}};

    /*
     * Unable to fully structure code
     */
    protected void openConnection(String host, int port, Properties info, String database, String url, Driver d) throws SQLException {
        if (info.getProperty("user") == null) {
            throw new PSQLException("postgresql.con.user");
        }
        if (info.getProperty("password") == null) {
            throw new PSQLException("postgresql.con.pass");
        }
        this.this_driver = d;
        this.this_url = new String(url);
        this.PG_DATABASE = new String(database);
        this.PG_PASSWORD = new String(info.getProperty("password"));
        this.PG_USER = new String(info.getProperty("user"));
        this.PG_PORT = port;
        this.PG_HOST = new String(host);
        this.PG_STATUS = this.CONNECTION_BAD;
        try {
            this.pg_stream = new PG_Stream(host, port);
        }
        catch (ConnectException v0) {
            throw new PSQLException("postgresql.con.refused");
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.con.failed", (Object)e);
        }
        try {
            this.pg_stream.SendInteger(296, 4);
            this.pg_stream.SendInteger(2, 2);
            this.pg_stream.SendInteger(0, 2);
            this.pg_stream.Send(database.getBytes(), 64);
            this.pg_stream.Send(this.PG_USER.getBytes(), 224);
            this.pg_stream.flush();
            areq = -1;
            block24: while (true) lbl-1000:
            // 3 sources

            {
                beresp = this.pg_stream.ReceiveChar();
                switch (beresp) {
                    case 69: {
                        throw new SQLException(this.pg_stream.ReceiveString(4096));
                    }
                    case 82: {
                        areq = this.pg_stream.ReceiveIntegerR(4);
                        if (areq == 4) {
                            rst = new byte[]{(byte)this.pg_stream.ReceiveChar(), (byte)this.pg_stream.ReceiveChar()};
                            this.salt = new String(rst, 0, 2);
                            DriverManager.println("Salt=" + this.salt);
                        }
                        switch (areq) {
                            case 1: {
                                DriverManager.println("postgresql: KRB4");
                                throw new PSQLException("postgresql.con.kerb4");
                            }
                            case 2: {
                                DriverManager.println("postgresql: KRB5");
                                throw new PSQLException("postgresql.con.kerb5");
                            }
                            case 3: {
                                DriverManager.println("postgresql: PASSWORD");
                                this.pg_stream.SendInteger(5 + this.PG_PASSWORD.length(), 4);
                                this.pg_stream.Send(this.PG_PASSWORD.getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                ** break;
                            }
                            case 4: {
                                DriverManager.println("postgresql: CRYPT");
                                crypted = UnixCrypt.crypt(this.salt, this.PG_PASSWORD);
                                this.pg_stream.SendInteger(5 + crypted.length(), 4);
                                this.pg_stream.Send(crypted.getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                ** break;
                            }
                            default: {
                                throw new PSQLException("postgresql.con.auth", new Integer(areq));
                            }
                            case 0: {
                                if (areq != 0) continue block24;
                            }
                        }
                    }
                    default: {
                        throw new PSQLException("postgresql.con.authfail");
                    }
                }
lbl67:
                // 2 sources

                if (areq != 0) ** GOTO lbl-1000
                break;
            }
        }
        catch (IOException e) {
            throw new PSQLException("postgresql.con.failed", (Object)e);
        }
        beresp = this.pg_stream.ReceiveChar();
        switch (beresp) {
            case 75: {
                this.pid = this.pg_stream.ReceiveInteger(4);
                this.ckey = this.pg_stream.ReceiveInteger(4);
                break;
            }
            case 69: 
            case 78: {
                throw new SQLException(this.pg_stream.ReceiveString(4096));
            }
            default: {
                throw new PSQLException("postgresql.con.setup");
            }
        }
        beresp = this.pg_stream.ReceiveChar();
        switch (beresp) {
            case 69: 
            case 78: {
                throw new SQLException(this.pg_stream.ReceiveString(4096));
            }
            default: {
                throw new PSQLException("postgresql.con.setup");
            }
            case 90: 
        }
        this.firstWarning = null;
        this.ExecSQL("set datestyle to 'ISO'");
        this.initObjectTypes();
        this.firstWarning = null;
        this.PG_STATUS = this.CONNECTION_OK;
    }

    public void addWarning(String msg) {
        DriverManager.println(msg);
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning(msg));
        } else {
            this.firstWarning = new SQLWarning(msg);
        }
    }

    /*
     * Unable to fully structure code
     */
    public ResultSet ExecSQL(String sql) throws SQLException {
        var3_2 = this.pg_stream;
        synchronized (var3_2) {
            fields = null;
            tuples = new Vector<byte[][]>();
            buf = new byte[sql.length()];
            fqp = 0;
            hfr = false;
            recv_status = null;
            update_count = 1;
            final_error = null;
            if (sql.length() > 8192) {
                throw new PSQLException("postgresql.con.toolong", (Object)sql);
            }
            try {
                this.pg_stream.SendChar(81);
                buf = sql.getBytes();
                this.pg_stream.Send(buf);
                this.pg_stream.SendChar(0);
                this.pg_stream.flush();
                if (true) ** GOTO lbl94
            }
            catch (IOException e) {
                throw new PSQLException("postgresql.con.ioerror", (Object)e);
            }
            block21: do {
                tup = null;
                c = this.pg_stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        this.pid = this.pg_stream.ReceiveInteger(4);
                        msg = this.pg_stream.ReceiveString(8192);
                        break;
                    }
                    case 66: {
                        if (fields == null) {
                            throw new PSQLException("postgresql.con.tuple");
                        }
                        tup = this.pg_stream.ReceiveTuple(fields.length, true);
                        if (this.maxrows != 0 && tuples.size() >= this.maxrows) continue block21;
                        tuples.addElement(tup);
                        break;
                    }
                    case 67: {
                        recv_status = this.pg_stream.ReceiveString(8192);
                        if (recv_status.startsWith("INSERT") || recv_status.startsWith("UPDATE")) {
                            try {
                                update_count = Integer.parseInt(recv_status.substring(1 + recv_status.lastIndexOf(32)));
                            }
                            catch (NumberFormatException v0) {
                                throw new PSQLException("postgresql.con.fathom", (Object)recv_status);
                            }
                        }
                        if (fields != null) {
                            hfr = true;
                            break;
                        }
                        try {
                            this.pg_stream.SendChar(81);
                            this.pg_stream.SendChar(32);
                            this.pg_stream.SendChar(0);
                            this.pg_stream.flush();
                        }
                        catch (IOException e) {
                            throw new PSQLException("postgresql.con.ioerror", (Object)e);
                        }
                        ++fqp;
                        break;
                    }
                    case 68: {
                        if (fields == null) {
                            throw new PSQLException("postgresql.con.tuple");
                        }
                        tup = this.pg_stream.ReceiveTuple(fields.length, false);
                        if (this.maxrows != 0 && tuples.size() >= this.maxrows) continue block21;
                        tuples.addElement(tup);
                        break;
                    }
                    case 69: {
                        msg = this.pg_stream.ReceiveString(4096);
                        final_error = new SQLException(msg);
                        hfr = true;
                        break;
                    }
                    case 73: {
                        t = this.pg_stream.ReceiveChar();
                        if (t != 0) {
                            throw new PSQLException("postgresql.con.garbled");
                        }
                        if (fqp > 0) {
                            --fqp;
                        }
                        if (fqp != 0) break;
                        hfr = true;
                        break;
                    }
                    case 78: {
                        this.addWarning(this.pg_stream.ReceiveString(4096));
                        break;
                    }
                    case 80: {
                        pname = this.pg_stream.ReceiveString(8192);
                        break;
                    }
                    case 84: {
                        if (fields != null) {
                            throw new PSQLException("postgresql.con.multres");
                        }
                        fields = this.ReceiveFields();
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.type", new Character((char)c));
                    }
                    case 90: 
                }
lbl94:
                // 15 sources

            } while (!hfr || fqp > 0);
            if (final_error != null) {
                throw final_error;
            }
            var2_18 = this.getResultSet(this, fields, tuples, recv_status, update_count);
            var4_19 = null;
            return var2_18;
        }
    }

    private Field[] ReceiveFields() throws SQLException {
        int nf = this.pg_stream.ReceiveIntegerR(2);
        Field[] fields = new Field[nf];
        int i = 0;
        while (i < nf) {
            String typname = this.pg_stream.ReceiveString(8192);
            int typid = this.pg_stream.ReceiveIntegerR(4);
            int typlen = this.pg_stream.ReceiveIntegerR(2);
            int typmod = this.pg_stream.ReceiveIntegerR(4);
            fields[i] = new Field(this, typname, typid, typlen, typmod);
            ++i;
        }
        return fields;
    }

    public void setCursorName(String cursor) throws SQLException {
        this.cursor = cursor;
    }

    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getURL() throws SQLException {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        return this.PG_USER;
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this, this.pg_stream);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    public Object getObject(String type, String value) throws SQLException {
        try {
            Object o = this.objectTypes.get(type);
            if (o == null) {
                Serialize ser = new Serialize(this, type);
                this.objectTypes.put(type, ser);
                return ser.fetch(Integer.parseInt(value));
            }
            if (o instanceof String) {
                PGobject obj = null;
                obj = (PGobject)Class.forName((String)o).newInstance();
                obj.setType(type);
                obj.setValue(value);
                return obj;
            }
            if (o instanceof Serialize) {
                return ((Serialize)o).fetch(Integer.parseInt(value));
            }
        }
        catch (SQLException sx) {
            sx.fillInStackTrace();
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException("postgresql.con.creobj", (Object)type, (Object)ex);
        }
        return null;
    }

    public int putObject(Object o) throws SQLException {
        try {
            String type = o.getClass().getName();
            Object x = this.objectTypes.get(type);
            if (x == null) {
                Serialize ser = new Serialize(this, type);
                this.objectTypes.put(type, ser);
                return ser.store(o);
            }
            if (x instanceof Serialize) {
                return ((Serialize)x).store(o);
            }
            throw new PSQLException("postgresql.con.strobj");
        }
        catch (SQLException sx) {
            sx.fillInStackTrace();
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException("postgresql.con.strobjex", (Object)ex);
        }
    }

    public void addDataType(String type, String name) {
        this.objectTypes.put(type, name);
    }

    private void initObjectTypes() {
        int i = 0;
        while (i < defaultObjectTypes.length) {
            this.objectTypes.put(defaultObjectTypes[i][0], defaultObjectTypes[i][1]);
            ++i;
        }
    }

    public abstract Statement createStatement() throws SQLException;

    protected abstract ResultSet getResultSet(Connection var1, Field[] var2, Vector var3, String var4, int var5) throws SQLException;

    public abstract void close() throws SQLException;

    public void finalize() throws Throwable {
        this.close();
    }

    public String EscapeSQL(String sql) {
        return sql;
    }
}

