/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.varia.ExternallyRolledFileAppender;

class HUPNode
implements Runnable {
    Socket socket;
    DataInputStream dis;
    DataOutputStream dos;
    ExternallyRolledFileAppender er;

    public void run() {
        try {
            String string = this.dis.readUTF();
            LogLog.debug("Got external roll over signal.");
            if ("RollOver".equals(string)) {
                ExternallyRolledFileAppender externallyRolledFileAppender = this.er;
                synchronized (externallyRolledFileAppender) {
                    this.er.rollOver();
                }
                this.dos.writeUTF("OK");
            } else {
                this.dos.writeUTF("Expecting [RollOver] string.");
            }
            this.dos.close();
        }
        catch (Exception exception) {
            LogLog.error("Unexptected exception. Exiting HUPNode.", exception);
        }
    }

    public HUPNode(Socket socket, ExternallyRolledFileAppender externallyRolledFileAppender) {
        this.socket = socket;
        this.er = externallyRolledFileAppender;
        try {
            this.dis = new DataInputStream(socket.getInputStream());
            this.dos = new DataOutputStream(socket.getOutputStream());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

