/*
 * Decompiled with CFR 0.152.
 */
package Free.DBPool;

import Free.DBPool.JDCConnectionPool;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class JDCConnection
implements Connection {
    private JDCConnectionPool pool;
    private Connection conn;
    private boolean inuse;
    private long timestamp;

    public JDCConnection(Connection connection, JDCConnectionPool jDCConnectionPool) {
        this.conn = connection;
        this.pool = jDCConnectionPool;
        this.inuse = false;
        this.timestamp = 0L;
    }

    public synchronized boolean lease() {
        if (this.inuse) {
            return false;
        }
        this.inuse = true;
        this.timestamp = System.currentTimeMillis();
        return true;
    }

    public boolean validate() {
        try {
            this.conn.getMetaData();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean inUse() {
        return this.inuse;
    }

    public long getLastUse() {
        return this.timestamp;
    }

    public void close() throws SQLException {
        this.pool.returnConnection(this);
    }

    protected void expireLease() {
        this.inuse = false;
    }

    protected Connection getConnection() {
        return this.conn;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.conn.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.conn.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.conn.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.conn.prepareCall(string);
    }

    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.conn.createStatement();
    }

    public String nativeSQL(String string) throws SQLException {
        return this.conn.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.conn.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.conn.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
        this.conn.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.conn.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }
}

