/*
 * Decompiled with CFR 0.152.
 */
package Free.util;

import Free.util.RSAPKCS1;
import Free.util.StringByteTools;
import cryptix.provider.Cryptix;
import cryptix.provider.cipher.Blowfish;
import cryptix.provider.key.RawSecretKey;
import cryptix.provider.padding.OneAndZeroes;
import cryptix.provider.rsa.RawRSAPrivateKey;
import cryptix.provider.rsa.RawRSAPublicKey;
import cryptix.util.core.Hex;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.StringTokenizer;
import xjava.security.Cipher;
import xjava.security.PaddingScheme;

public class RSAEncrypt {
    private static SecureRandom rnd;

    public static void init() throws Exception {
        try {
            Security.addProvider((Provider)new Cryptix());
            rnd = new SecureRandom();
            rnd.nextInt();
        }
        catch (Exception exception) {
            throw new Exception("RSA Encrypt initialistion error: " + exception.toString());
        }
    }

    public static String pubEncrypt(String string, String string2) throws Exception {
        String string3 = "";
        try {
            RawRSAPublicKey rawRSAPublicKey = new RawRSAPublicKey((InputStream)new ByteArrayInputStream(Hex.fromString((String)string)));
            RSAPKCS1 rSAPKCS1 = new RSAPKCS1(rnd);
            rSAPKCS1.initEncrypt((Key)rawRSAPublicKey);
            string3 = Hex.toString((byte[])rSAPKCS1.crypt(StringByteTools.asciiGetBytes(string2)));
        }
        catch (Exception exception) {
            throw new Exception("RSAEncrypt.pubEncrypt: " + exception.getMessage());
        }
        return string3;
    }

    public static String privDecrypt(String string, String string2) throws Exception {
        String string3 = "";
        try {
            RawRSAPrivateKey rawRSAPrivateKey = new RawRSAPrivateKey((InputStream)new ByteArrayInputStream(Hex.fromString((String)string)));
            RSAPKCS1 rSAPKCS1 = new RSAPKCS1();
            rSAPKCS1.initDecrypt((Key)rawRSAPrivateKey);
            string3 = StringByteTools.asciiGetString(rSAPKCS1.crypt(Hex.fromString((String)string2)));
        }
        catch (Exception exception) {
            throw new Exception("RSAEncrypt.privDecrypt: " + exception.getMessage());
        }
        return string3;
    }

    public static String makeSessionKey() throws Exception {
        String string = "";
        try {
            byte[] byArray = new byte[100];
            rnd.nextBytes(byArray);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            string = Hex.toString((byte[])byArray2);
        }
        catch (Exception exception) {
            throw new Exception("RSAEncrypt.makeSessionKey: " + exception.getMessage());
        }
        return string;
    }

    public static String blowEncrypt(String string, String string2) throws Exception {
        Cipher cipher = Cipher.getInstance((Cipher)new Blowfish(), null, (PaddingScheme)new OneAndZeroes());
        RawSecretKey rawSecretKey = new RawSecretKey("Blowfish", Hex.fromString((String)string));
        cipher.initEncrypt((Key)rawSecretKey);
        byte[] byArray = cipher.crypt(StringByteTools.asciiGetBytes(string2));
        return Hex.toString((byte[])byArray);
    }

    public static String blowDecrypt(String string, String string2) throws Exception {
        Cipher cipher = Cipher.getInstance((Cipher)new Blowfish(), null, (PaddingScheme)new OneAndZeroes());
        RawSecretKey rawSecretKey = new RawSecretKey("Blowfish", Hex.fromString((String)string));
        cipher.initDecrypt((Key)rawSecretKey);
        byte[] byArray = cipher.crypt(Hex.fromString((String)string2));
        return StringByteTools.asciiGetString(byArray);
    }

    public static String[] splitnDecrypt(String string, String string2) throws Exception {
        int n = 0;
        String string3 = "";
        String[] stringArray = new String[]{"", ""};
        String[] stringArray2 = new String[]{"", ""};
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "-", false);
        while (stringTokenizer.hasMoreTokens() && n < stringArray2.length) {
            stringArray2[n] = stringTokenizer.nextToken();
            ++n;
        }
        stringArray[0] = string3 = RSAEncrypt.privDecrypt(string, stringArray2[0]);
        stringArray[1] = RSAEncrypt.blowDecrypt(string3, stringArray2[1]);
        return stringArray;
    }
}

