/*
 * Decompiled with CFR 0.152.
 */
package Free.util;

import Free.util.AuthSys;
import Free.util.RSAEncrypt;
import java.util.StringTokenizer;

public class Packet {
    private char type;
    private String message;
    private String digest;
    private String session_key;
    private String RSA_key;
    private String HMAC_key;
    private int seq_no;

    public Packet(String string) {
        int n = 2;
        this.type = string.charAt(0);
        while (string.charAt(n) != '|') {
            ++n;
        }
        this.message = n == 2 ? "" : string.substring(2, n);
        this.digest = string.substring(n + 1);
    }

    public Packet(char c, String string, String string2, String string3, String string4, int n) throws Exception {
        this.type = c;
        this.message = string;
        this.session_key = string2;
        this.RSA_key = string3;
        this.HMAC_key = string4;
        this.seq_no = n;
        this.digest = AuthSys.makeHMAC(String.valueOf(this.type) + "|" + this.message, this.HMAC_key, this.seq_no);
    }

    public String toString() {
        String string = String.valueOf(this.type) + "|" + this.message + "|" + this.digest;
        return string;
    }

    public String toCryptString(boolean bl) throws Exception {
        String string = bl ? String.valueOf(RSAEncrypt.pubEncrypt(this.RSA_key, this.session_key)) + "-" + RSAEncrypt.blowEncrypt(this.session_key, String.valueOf(this.type) + "|" + this.message + "|" + this.digest) + "\r\n" : String.valueOf(RSAEncrypt.blowEncrypt(this.session_key, String.valueOf(this.type) + "|" + this.message + "|" + this.digest)) + "\r\n";
        return string;
    }

    public String[] splitMessage() {
        int n = 0;
        String[] stringArray = new String[]{"", "", "", "", "", "", "", "", "", ""};
        StringTokenizer stringTokenizer = new StringTokenizer(this.message, "-", false);
        while (stringTokenizer.hasMoreTokens() && n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMACMessage() {
        String string = String.valueOf(this.type) + "|" + this.message;
        return string;
    }

    public String getDigest() {
        return this.digest;
    }

    public char getType() {
        return this.type;
    }
}

