/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import org.hsql.Channel;
import org.hsql.Database;
import org.hsql.Result;
import org.hsql.StringConverter;
import org.hsql.Trace;
import org.hsql.jdbcDatabaseMetaData;
import org.hsql.jdbcPreparedStatement;
import org.hsql.jdbcResultSet;
import org.hsql.jdbcStatement;

public class jdbcConnection
implements Connection {
    private boolean bClosed;
    private boolean bReadOnly;
    private boolean bEscape;
    private boolean bAutoCommit = true;
    private String sDatabaseName;
    private boolean bStandalone;
    private String sConnect;
    private String sUser;
    private String sPassword;
    static final String ENCODING = "8859_1";
    private Database dDatabase;
    private Channel cChannel;
    private static Hashtable tDatabase = new Hashtable();
    private static Hashtable iUsageCount = new Hashtable();

    public Statement createStatement() {
        if (this.bClosed) {
            return null;
        }
        return new jdbcStatement(this);
    }

    public PreparedStatement prepareStatement(String string) {
        if (this.bClosed) {
            return null;
        }
        return new jdbcPreparedStatement(this, string);
    }

    public CallableStatement prepareCall(String string) {
        if (this.bClosed) {
            return null;
        }
        return new jdbcPreparedStatement(this, string);
    }

    public String nativeSQL(String string) {
        if (string.indexOf(123) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        break;
                    }
                    if (c == '\"') {
                        n = 2;
                        break;
                    }
                    if (c != '{') break;
                    cArray[n3] = 32;
                    bl = true;
                    String string2 = string.substring(n3 + 1).toUpperCase();
                    if (string2.startsWith("?=")) {
                        n3 += 2;
                    } else if (string2.startsWith("CALL")) {
                        n3 += 4;
                    } else if (string2.startsWith("ESCAPE")) {
                        n3 += 6;
                    }
                    n = 3;
                    break;
                }
                case 1: 
                case 5: {
                    if (c != '\'') break;
                    --n;
                    break;
                }
                case 2: 
                case 6: {
                    if (c != '\"') break;
                    n -= 2;
                    break;
                }
                case 3: {
                    if (c == ' ') {
                        n = 4;
                        break;
                    }
                    cArray[n3] = 32;
                    bl = true;
                    break;
                }
                case 4: {
                    if (c == '\'') {
                        n = 5;
                        break;
                    }
                    if (c == '\"') {
                        n = 6;
                        break;
                    }
                    if (c != '}') break;
                    cArray[n3] = 32;
                    bl = true;
                    n = 0;
                }
            }
            ++n3;
        }
        if (bl) {
            string = new String(cArray);
        }
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.bAutoCommit = bl;
        this.execute("SET AUTOCOMMIT " + (this.bAutoCommit ? "TRUE" : "FALSE"));
    }

    public boolean getAutoCommit() {
        return this.bAutoCommit;
    }

    public void commit() throws SQLException {
        this.execute("COMMIT");
    }

    public void rollback() throws SQLException {
        this.execute("ROLLBACK");
    }

    public void close() throws SQLException {
        if (this.bClosed) {
            return;
        }
        if (this.bStandalone) {
            this.closeStandalone();
        }
        this.bClosed = true;
    }

    public boolean isClosed() {
        return this.bClosed;
    }

    public DatabaseMetaData getMetaData() {
        return new jdbcDatabaseMetaData(this);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.execute("SET READONLY " + (bl ? "TRUE" : "FALSE"));
    }

    public boolean isReadOnly() throws SQLException {
        String string = "SELECT * FROM SYSTEM_CONNECTIONINFO WHERE KEY='READONLY'";
        jdbcResultSet jdbcResultSet2 = this.execute(string);
        jdbcResultSet2.next();
        return jdbcResultSet2.getString(2).equals("TRUE");
    }

    public void setCatalog(String string) {
    }

    public String getCatalog() {
        return null;
    }

    public void setTransactionIsolation(int n) {
    }

    public int getTransactionIsolation() {
        return 1;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    jdbcConnection(String string, String string2, String string3) throws SQLException {
        this.sDatabaseName = string;
        if (string.toUpperCase().startsWith("HTTP://")) {
            this.openHTTP(string2, string3);
            return;
        }
        this.bStandalone = true;
        this.openStandalone(string2, string3);
    }

    jdbcResultSet execute(String string) throws SQLException {
        Trace.check(!this.bClosed, 17);
        if (this.bStandalone) {
            return this.executeStandalone(string);
        }
        return this.executeHTTP(string);
    }

    boolean usesLocalFiles() {
        return this.bStandalone;
    }

    String getName() {
        return this.sDatabaseName;
    }

    private void openHTTP(String string, String string2) throws SQLException {
        this.sConnect = this.sDatabaseName;
        this.sUser = string;
        this.sPassword = string2;
        this.executeHTTP(" ");
    }

    private jdbcResultSet executeHTTP(String string) throws SQLException {
        byte[] byArray;
        try {
            URL uRL = new URL(this.sConnect);
            String string2 = StringConverter.unicodeToHexString(this.sUser);
            string2 = String.valueOf(string2) + "+" + StringConverter.unicodeToHexString(this.sPassword);
            string2 = String.valueOf(string2) + "+" + StringConverter.unicodeToHexString(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            OutputStream outputStream = uRLConnection.getOutputStream();
            outputStream.write(string2.getBytes(ENCODING));
            outputStream.close();
            uRLConnection.connect();
            InputStream inputStream = (InputStream)uRLConnection.getContent();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n = uRLConnection.getContentLength();
            byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = bufferedInputStream.read();
                byArray[n2] = (byte)n3;
                ++n2;
            }
        }
        catch (Exception exception) {
            throw Trace.error(19, exception.getMessage());
        }
        return new jdbcResultSet(new Result(byArray));
    }

    private void openStandalone(String string, String string2) throws SQLException {
        int n;
        this.dDatabase = (Database)tDatabase.get(this.sDatabaseName);
        if (this.dDatabase == null) {
            this.dDatabase = new Database(this.sDatabaseName);
            tDatabase.put(this.sDatabaseName, this.dDatabase);
            n = 1;
        } else {
            n = 1 + (Integer)iUsageCount.get(this.sDatabaseName);
        }
        iUsageCount.put(this.sDatabaseName, new Integer(n));
        this.cChannel = this.dDatabase.connect(string, string2);
    }

    public void finalize() {
        try {
            this.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private void closeStandalone() throws SQLException {
        Integer n = (Integer)iUsageCount.get(this.sDatabaseName);
        Trace.assert(n != null, "i==null");
        int n2 = n - 1;
        if (n2 == 0) {
            iUsageCount.remove(this.sDatabaseName);
            tDatabase.remove(this.sDatabaseName);
            if (!this.dDatabase.isShutdown()) {
                this.execute("SHUTDOWN");
            }
            this.dDatabase = null;
            this.cChannel = null;
            return;
        }
        iUsageCount.put(this.sDatabaseName, new Integer(n2));
    }

    private jdbcResultSet executeStandalone(String string) throws SQLException {
        return new jdbcResultSet(this.dDatabase.execute(string, this.cChannel));
    }
}

